<?php $__env->startSection('content'); ?>
    <div class="p-4">
        <div class="bg-white rounded-lg overflow-hidden relative">
            <div class="flex absolute top-2 left-2">
                <a href="<?php echo e(route('category.index')); ?>" class="text-xs md:text-sm font-medium text-blue-500 flex items-center transition-all duration-300 bg-white/[0.5] hover:bg-white/[0.8] p-2 md:p-3 rounded-lg backdrop-blur-sm border border-white">
                    <i data-feather="arrow-left" class="w-4 h-4 md:w-5 md:h-5 text-sky-600"></i>
                    <span class="ml-2 text-sky-600">Detail Buku</span>
                </a>
            </div>
            <img src="<?php echo e(asset('storage/' . $category->image)); ?>" alt="Category Image" class="img-fluid">
            <div class="p-4 md:p-7">
                <div class="flex items-center mb-4 md:mb-6">
                    <img src="<?php echo e(asset('storage/' . $category->image)); ?>" alt="<?php echo e($category->name); ?>"
                        class="w-16 h-16 md:w-20 md:h-20 rounded-full" />
                    <div class="ml-3">
                        <h1 class="text-gray-700 text-lg md:text-2xl font-bold"><?php echo e($category->name); ?></h1>
                        <p class="text-gray-600 text-xs md:text-sm"><?php echo e($category->name); ?></p>
                        <p class="text-gray-600 text-xs md:text-sm"><?php echo e($category->books->count()); ?> buku</p>
                    </div>
                </div>
                <h1 class="text-gray-700 text-md md:text-lg font-semibold">Books</h1>
                <div class="grid grid-cols-2 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4 md:gap-6 mb-8">
                    <?php $__currentLoopData = $category->books; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $book): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('books.show', $book->slug)); ?>"
                            class="group transition rounded-md hover:scale-95 duration-300 relative">
                            <?php
                                $dipinjam = false;
                            ?>
                            <?php if($book->borrow->isNotEmpty()): ?>
                                <?php $__currentLoopData = $book->borrow; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $borrow): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($borrow->user_id == auth()->user()->id && $borrow->status == 'meminjam'): ?>
                                        <?php
                                            $dipinjam = true;
                                        ?>
                                        <div class="bg-zinc-800 p-1 md:p-3 text-white rounded-r text-xs md:text-sm absolute top-3">Dipinjam
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <?php if($dipinjam == false): ?>
                                <?php if($book->stok == 0): ?>
                                    <div class="bg-zinc-800 p-1 md:p-3 text-white rounded-r text-xs md:text-sm absolute top-3">Tidak Tersedia
                                    </div>
                                <?php else: ?>
                                    <div class="bg-green-600 p-1 md:p-3 text-white rounded-r text-xs md:text-sm absolute top-3">Tersedia</div>
                                <?php endif; ?>
                            <?php endif; ?>
                            <img src="<?php echo e(asset('storage/' . $book->image)); ?>" alt="gusdur" class="w-full h-40 md:h-96 object-cover rounded">
                            <h1 class="mt-2 font-bold text-sm md:text-lg text-gray-700 truncate group-hover:truncate-none peer">
                                <?php echo e($book->title); ?></h1>
                            <div
                                class="p-2 absolute bg-white shadow-lg border border-slate-300 rounded right-0 left-0 transition-all duration-300 z-[-10] peer-hover:z-10 opacity-0 translate-y-5 peer-hover:translate-y-0 peer-hover:opacity-100 hover:translate-y-0 hover:opacity-100 hover:z-10">
                                <?php echo e($book->title); ?></div>
                            <div class="text-xs md:text-sm flex text-gray-700 items-center font-medium">
                                <i data-feather="edit-3" width="14px" md:width="16px"></i>
                                <span class="ml-2"><?php echo e($book->penulis); ?></span>
                            </div>
                            <div class="text-xs md:text-sm flex text-gray-700 items-center font-medium">
                                <i data-feather="calendar" width="14px" md:width="16px"></i>
                                <span class="ml-2">Maret 20, 2022</span>
                            </div>
                            <div class="text-xs md:text-sm flex text-gray-700 items-center font-medium">
                                <i data-feather="layers" width="14px" md:width="16px"></i>
                                <span class="ml-2">200 Pages</span>
                            </div>
                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\vinad\Downloads\propus\resources\views\category\show.blade.php ENDPATH**/ ?>