<?php $__env->startSection('content'); ?>
    <div class="p-4 h-full">
        <div class="w-full bg-white rounded-lg p-3">
            <div class="flex">
                <a href="<?php echo e(route('books.index')); ?>" class="text-sm font-medium text-blue-500 flex items-center">
                    <i data-feather="arrow-left" class="w-5 h-5 text-sky-600"></i>
                    <span class="ml-2 text-sky-600">Detail Buku</span>
                </a>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mt-3 relative">
                <div class="flex flex-col items-center md:sticky md:top-0">
                    <img src="<?php echo e(asset('storage/' . $book->image)); ?>" alt="<?php echo e($book->title); ?>" class="w-full h-64 md:h-96 object-cover rounded-lg shadow-lg">
                    <form action="<?php echo e(route('borrow.store')); ?>" method="post" class="w-full mt-4">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="user_id" value="<?php echo e(auth()->user()->id); ?>">
                        <input type="hidden" name="book_id" value="<?php echo e($book->id); ?>">
                        <input type="hidden" name="kode_peminjaman" value="<?php echo e(date('d') . auth()->user()->id . $book->kode_buku); ?>">
                        <input type="hidden" name="status" value="meminjam">
                        <button type="submit" class="w-full mt-3 transition-all duration-500 bg-gradient-to-br from-blue-400 to-blue-600 rounded-lg text-white font-medium p-4 text-sm shadow-lg hover:shadow-xl hover:bg-blue-600 focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 text-center disabled:bg-slate-700 disabled:cursor-not-allowed"
                            <?php if($book->stok == 0): ?> 
                                <?php if(true): echo 'disabled'; endif; ?> 
                            <?php elseif($book->borrow->isNotEmpty()): ?> 
                                <?php $__currentLoopData = $book->borrow->where('status', 'meminjam'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $borrow): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($book->stok == 0 || $borrow->user_id == auth()->user()->id): ?>
                                        <?php if(true): echo 'disabled'; endif; ?> 
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>>
                            Pinjam
                        </button>
                    </form>
                    <?php if($book->borrow->where('status', 'meminjam')->where('user_id', auth()->user()->id)->isNotEmpty()): ?>
                        <form action="<?php echo e(route('borrow.return', $book->borrow->where('status', 'meminjam')->first()->id)); ?>" method="post" class="w-full">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="w-full mt-3 bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-4 rounded">
                                Kembalikan
                            </button>
                        </form>
                    <?php endif; ?>
                    <p class="text-slate-700 mt-2 text-sm font-medium">Jumlah Buku : <?php echo e($book->stok); ?></p>
                </div>
                <div class="col-span-3">
                    <h1 class="text-2xl md:text-3xl font-semibold text-slate-800"><?php echo e($book->title); ?></h1>
                    <h2 class="text-sm md:text-base font-medium mt-2 text-slate-700">
                        <?php echo e($book->penulis); ?> - <?php echo e($book->penerbit); ?>

                    </h2>
                    <div class="flex flex-wrap items-center mt-2">
                        <div class="flex items-center">
                            <?php if($book->histories): ?>
                                <?php if($book->histories->isNotEmpty()): ?>
                                    <?php $__currentLoopData = $book->histories->unique('user_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <img src="<?php echo e(asset('storage/' . $history->user->image)); ?>" alt="<?php echo e($history->user->name); ?>" class="w-8 h-8 md:w-10 md:h-10 overflow-hidden rounded-full object-cover border border-white relative -ml-3">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                <span class="text-slate-700 ml-2"><?php echo e($book->histories->count()); ?> people have read</span>
                            <?php endif; ?>
                        </div>
                        <div class="flex mt-2 ml-4">
                            <h2 class="text-slate-700">| Kategori :</h2>
                            <a href="<?php echo e(route('category.show', $book->category->slug)); ?>" class="text-slate-700 ml-1 underline decoration-double decoration-blue-600">
                                <?php echo e($book->category->name); ?>

                            </a>
                        </div>
                    </div>
                    <p class="text-base text-slate-700 mt-2"><?php echo e($book->description); ?></p>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\vinad\Downloads\propus\resources\views\book\show.blade.php ENDPATH**/ ?>