<!DOCTYPE html>
<html lang="idn" class="scroll-smooth">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    
    <title>PDF</title>
</head>

<body class="w-full h-screen overflow-hidden">

    <div class="p-8">
        <div class="p-5 bg-white rounded-lg">
            <div class="grid grid-cols-3 gap-4 p-4">
                
                <img src="<?php echo e('storage/' . $borrow['image']); ?>" alt="image" class="object-cover">
                <div>
                    <div class="mb-2">
                        <h1 class="font-semibold text-gray-800 text-lg">Judul</h1>
                        <p class="text-gray-800 text-base"><?php echo e($borrow['title']); ?></p>
                    </div>
                    <div class="mb-2">
                        <h1 class="font-semibold text-gray-800 text-lg">Kode Buku</h1>
                        <p class="text-gray-800 text-base"><?php echo e($borrow['kode']); ?></p>
                    </div>
                    <div class="mb-2">
                        <h1 class="font-semibold text-gray-800 text-lg">Peminjam</h1>
                        <p class="text-gray-800 text-base"><?php echo e($borrow['peminjam']); ?></p>
                    </div>
                    <div class="mb-2">
                        <h1 class="font-semibold text-gray-800 text-lg">Dipinjam</h1>
                        <p class="text-gray-800 text-base bg-gradient-to-br from-green-500 to-green-600 inline-block text-white p-1 px-2 rounded mt-px"><?php echo e($borrow['created_at']->setTimezone('Asia/Jakarta')->format('d M Y')); ?></p>
                    </div>
                    <div class="mb-2">
                        <h1 class="font-semibold text-gray-800 text-lg">Dikembalikan</h1>
                        <?php if($borrow['status'] == 'meminjam'): ?>
                            <p class="text-gray-800 text-base bg-gradient-to-br from-red-500 to-red-600 inline-block text-white p-1 px-2 rounded mt-px">Belum dikembalikan</p>
                        <?php else: ?>
                            <p class="text-gray-800 text-base bg-gradient-to-br from-green-500 to-green-600 inline-block text-white p-1 px-2 rounded mt-px"><?php echo e($borrow['updated_at']->setTimezone('Asia/Jakarta')->format('d M Y')); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://unpkg.com/feather-icons"></script>
    <script>
        feather.replace()

        function showPreview(event) {
            if (event.target.files.length > 0) {
                var src = URL.createObjectURL(event.target.files[0]);
                var preview = document.getElementById("file-ip-1-preview");
                preview.src = src;
                preview.style.display = "block";
            }
        }
        const clsNotif = document.querySelector('#btn-notif');
        const notif = document.querySelector('#hilangkan');

        clsNotif.onclick = function() {
            notif.classList.add("hidden");
        }
    </script>+
</body>

</html><?php /**PATH C:\Users\vinad\Downloads\propus\resources\views\pdf-template.blade.php ENDPATH**/ ?>