

<?php $__env->startSection('contentAdmin'); ?>
    <div class="p-4">
        <div class="flex justify-between items-center">
            <h1 class="text-lg font-semibold text-gray-800 mb-3">Daftar User</h1>
        </div>
        <div class="mt-6">
            <div class="overflow-auto rounded-lg shadow hidden lg:block w-full mt-5">
                <table class="table-auto w-full">
                    <thead class="bg-gray-50 border-b-2 border-gray-200">
                        <tr>
                            <th class="w-6 p-3 text-sm font-semibold tracking-wide text-left">#</th>
                            <th class="w-32 p-3 text-sm font-semibold tracking-wide text-left">Nama</th>
                            <th class="w-32 p-3 text-sm font-semibold tracking-wide text-left">Username</th>
                            <th class="w-44 p-3 text-sm font-semibold tracking-wide text-left">Email</th>
                            <th class="w-44 p-3 text-sm font-semibold tracking-wide text-left">Alamat</th>
                            <th class="w-32 p-3 text-sm font-semibold tracking-wide text-left">Status</th>
                            <th class="w-32 p-3 text-sm font-semibold tracking-wide text-left">Foto Profil</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap"><?php echo e($loop->iteration); ?></td>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap"><?php echo e($user->name); ?></td>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap"><?php echo e($user->username); ?></td>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap"><?php echo e($user->email); ?></td>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap max-w-xs overflow-hidden text-ellipsis"><?php echo e($user->address); ?></td>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap"><?php echo e($user->status); ?></td>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap">
                                    <?php if($user->profile_image): ?>
                                        <img src="<?php echo e(asset('storage/' . $user->profile_image)); ?>" alt="Foto Profil" class="w-24 h-32 object-cover rounded">
                                    <?php else: ?>
                                        <span class="text-gray-500">Tidak ada foto</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center p-5 text-gray-500">Tidak ada data user</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\vinad\Downloads\propus\resources\views/admin/members/index.blade.php ENDPATH**/ ?>