<!DOCTYPE html>
<html lang="en">

  <head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css">


    <title>EPERPUS DLHK</title>

    <!-- Bootstrap core CSS -->
    <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">


    <!-- Additional CSS Files -->
    <link rel="stylesheet" href="assets/css/fontawesome.css">
    <link rel="stylesheet" href="assets/css/templatemo-villa-agency.css">
    <link rel="stylesheet" href="assets/css/owl.css">
    <link rel="stylesheet" href="assets/css/animate.css">
    <link rel="stylesheet"href="https://unpkg.com/swiper@7/swiper-bundle.min.css"/>
<!--

TemplateMo 591 villa agency

https://templatemo.com/tm-591-villa-agency

-->
  </head>

<body>

  <!-- ***** Preloader Start ***** -->
  <div id="js-preloader" class="js-preloader">
    <div class="preloader-inner">
      <span class="dot"></span>
      <div class="dots">
        <span></span>
        <span></span>
        <span></span>
      </div>
    </div>
  </div>
  <!-- ***** Preloader End ***** -->

<!-- ***** Header Area Start ***** -->
<header class="header-area header-sticky">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <nav class="main-nav">
                    <!-- ***** Logo Start ***** -->
                    <a href="<?php echo e(route('welcome')); ?>" class="logo">
                        <h1>ELIBRARY</h1>
                    </a>
                    <!-- ***** Logo End ***** -->
                    <!-- ***** Menu Start ***** -->
                    <ul class="nav">
                      <li><a href="<?php echo e(route('welcome')); ?>" class="active">Home</a></li>
                      <li><a href="#instansi">Instansi</a></li>
                      <li><a href="#tentang-perpustakaan">Tentang Perpustakaan</a></li>
                      <li><a href="#koleksi-buku">Koleksi Buku</a></li>
                      <?php if(Auth::check()): ?>
                            <!-- Menampilkan nama user dan tombol logout jika sudah login -->
                            <li><a href="#" class="user-name">Hi, <?php echo e(Auth::user()->name); ?></a></li>
                            <li><a href="<?php echo e(route('logout')); ?>" 
                                   onclick="event.preventDefault(); document.getElementById('logout-form').submit();" 
                                   class="btn-logout">Logout</a></li>
                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                <?php echo csrf_field(); ?>
                            </form>
                        <?php else: ?>
                            <!-- Tampilkan tombol login dan register jika belum login -->
                            <li><a href="<?php echo e(route('login')); ?>" class="btn-login">Login</a></li>
                            <li><a href="<?php echo e(route('register')); ?>"><i class="fa fa-calendar"></i>Register</a></li>
                        <?php endif; ?>
                    </ul>   
                    <a class='menu-trigger'>
                        <span>Menu</span>
                    </a>
                    <!-- ***** Menu End ***** -->
                </nav>
            </div>
        </div>
    </div>
  </header>
  <!-- ***** Header Area End ***** -->

  <div class="main-banner">
  <div class="owl-carousel owl-banner">
    <div class="item item-1">
      <img src="assets/images/1.png" alt="Banner 1" class="banner-image">
    </div>
    <div class="item item-2">
      <img src="assets/images/2.png" alt="Banner 2" class="banner-image">
    </div>
    <div class="item item-3">
      <img src="assets/images/3.png" alt="Banner 3" class="banner-image">
    </div>
  </div>
  <!-- Tombol Prev dan Next -->
  <div class="owl-prev"></div>
  <div class="owl-next"></div>
</div>

  <section id="instansi" class="featured section">
    <div class="container">
        <div class="row">
            <div class="col-lg-4">
                <div class="left-image">
                    <img src="assets/images/dlhk.jpg" alt="">
                    <a href="property-details.html">
                        <img src="assets/images/featured-icon.png" alt="" style="max-width: 60px; padding: 0px;">
                    </a>
                </div>
            </div>
            <div class="col-lg-5">
                <div class="section-heading">
                    <h6>| Instansi</h6>
                    <h2>Dinas Lingkungan Hidup dan Kehutanan DIY</h2>
                </div>
                <div class="accordion" id="accordionExample">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                Apa Itu DLHK DIY?
                            </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <strong>DLHK DIY</strong> adalah instansi yang mengelola lingkungan hidup dan kehutanan di Yogyakarta, termasuk pengawasan kualitas lingkungan, pengelolaan sampah, dan pelestarian hutan.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="info-table">
                    <ul>
                        <li>
                            <img src="assets/images/info-icon-04.png" alt="" style="max-width: 52px;">
                            <h4>Sekretariat<br><span>Pelayanan Umum</span></h4>
                        </li>
                        <li>
                            <img src="assets/images/info-icon-01.png" alt="" style="max-width: 52px;">
                            <h4>P2KLH<br><span>Pemetaan</span></h4>
                        </li>
                        <li>
                            <img src="assets/images/info-icon-02.png" alt="" style="max-width: 52px;">
                            <h4>P3KLH<br><span>Perizinan</span></h4>
                        </li>
                        <li>
                            <img src="assets/images/info-icon-03.png" alt="" style="max-width: 52px;">
                            <h4>Balai Sampah<br><span>Pengolahan Sampah</span></h4>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<div class="fun-facts">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="wrapper">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="counter">
                                <h2 class="timer count-title count-number" data-to="<?php echo e($totalBooks); ?>" data-speed="1000"></h2>
                                <p class="count-text">Total Buku<br>Yang Tersedia</p>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="counter">
                                <h2 class="timer count-title count-number" data-to="<?php echo e($totalBorrowedBooks); ?>" data-speed="1000"></h2>
                                <p class="count-text">Total Peminjaman<br>Buku</p>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="counter">
                                <h2 class="timer count-title count-number" data-to="<?php echo e($totalVisitors); ?>" data-speed="1000"></h2>
                                <p class="count-text">Total Pengunjung<br>Hari Ini</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function () {
    $('.timer').each(function () {
        $(this).prop('Counter', 0).animate({
            Counter: $(this).data('to')
        }, {
            duration: $(this).data('speed'),
            easing: 'swing',
            step: function (now) {
                $(this).text(Math.ceil(now));
            }
        });
    });
});
</script>


  <section id="tentang-perpustakaan">
  <div class="section best-deal">
    <div class="container">
      <div class="row">
        <div class="col-lg-4">
          <div class="section-heading">
            <h6>| EPERPUS</h6>
            <h2>Tentang E-Library DLHK DIY</h2>
          </div>
        </div>
        <div class="col-lg-12">
          <div class="tabs-content">
            <div class="row">
              <div class="nav-wrapper">
                <ul class="nav nav-tabs" role="tablist">
                  <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="appartment-tab" data-bs-toggle="tab" data-bs-target="#appartment" type="button" role="tab" aria-controls="appartment" aria-selected="true">Aksesibilitas</button>
                  </li>
                  <li class="nav-item" role="presentation">
                    <button class="nav-link" id="villa-tab" data-bs-toggle="tab" data-bs-target="#villa" type="button" role="tab" aria-controls="villa" aria-selected="false">Efisiensi</button>
                  </li>
                  <li class="nav-item" role="presentation">
                    <button class="nav-link" id="penthouse-tab" data-bs-toggle="tab" data-bs-target="#penthouse" type="button" role="tab" aria-controls="penthouse" aria-selected="false">Digitalisasi</button>
                  </li>
                </ul>
              </div>              
              <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade show active" id="appartment" role="tabpanel" aria-labelledby="appartment-tab">
                  <div class="row">
                    <div class="col-lg-3">
                      <div class="info-table">
                        <ul>
                          <li>Aplikasi Berbasis Web <span>Certainly</span></li>
                          <li>Akses Koleksi <span>Certainly</span></li>
                          <li>Fitur Utama <span>Certainly</span></li>
                          <li>Transformasi Teknologi <span>Certainly</span></li>
                          <li>Akses Mudah <span>Certainly</span></li>
                        </ul>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <img src="assets/images/p1.jpg" alt="">
                    </div>
                    <div class="col-lg-3">
                      <h4>Aksesibilitas</h4>
                      <p>Aplikasi perpustakaan digital memudahkan masyarakat untuk mengakses koleksi buku, jurnal, dan dokumen penting dengan cepat dan mudah. 
                      <br><br>Dengan adanya layanan ini, pengguna dapat menemukan informasi yang dibutuhkan kapan saja dan di mana saja tanpa batasan waktu dan ruang. Hal ini mendorong partisipasi aktif masyarakat dalam memperluas pengetahuan dan literasi lingkungan.</p>
                    </div>
                  </div>
                </div>
                <div class="tab-pane fade" id="villa" role="tabpanel" aria-labelledby="villa-tab">
                  <div class="row">
                    <div class="col-lg-3">
                      <div class="info-table">
                        <ul>
                          <li>Aplikasi Berbasis Web <span>Certainly</span></li>
                          <li>Akses Koleksi <span>Certainly</span></li>
                          <li>Fitur Utama <span>Certainly</span></li>
                          <li>Transformasi Teknologi <span>Certainly</span></li>
                          <li>Akses Mudah <span>Certainly</span></li>
                        </ul>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <img src="assets/images/p1.jpg" alt="">
                    </div>
                    <div class="col-lg-3">
                      <h4>Efisiensi</h4>
                      <p>Fitur pencarian cepat dan peminjaman e-book dalam aplikasi ini meningkatkan efisiensi layanan perpustakaan. Hal ini memungkinkan pengguna untuk mendapatkan literatur yang mereka butuhkan secara lebih efektif, mendukung proses pembelajaran dan penelitian. Dengan demikian, pengguna dapat memanfaatkan waktu mereka dengan lebih baik dan fokus pada tujuan pembelajaran mereka.</p>
                    </div>
                  </div>
                </div>
                <div class="tab-pane fade" id="penthouse" role="tabpanel" aria-labelledby="penthouse-tab">
                  <div class="row">
                    <div class="col-lg-3">
                      <div class="info-table">
                        <ul>
                          <li>Aplikasi Berbasis Web <span>Certainly</span></li>
                          <li>Akses Koleksi <span>Certainly</span></li>
                          <li>Fitur Utama <span>Certainly</span></li>
                          <li>Transformasi Teknologi <span>Certainly</span></li>
                          <li>Akses Mudah <span>Certainly</span></li>
                        </ul>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <img src="assets/images/p1.jpg" alt="">
                    </div>
                    <div class="col-lg-3">
                      <h4>Digitalisasi</h4>
                      <p>Inovasi dalam pembuatan aplikasi berbasis web sejalan dengan tren digitalisasi yang berkembang saat ini. Transformasi teknologi ini bertujuan untuk memberikan layanan yang lebih baik dan relevan kepada masyarakat luas, menciptakan pengalaman perpustakaan yang lebih modern dan interaktif. Selain itu, digitalisasi memungkinkan perpustakaan untuk menjangkau audiens yang lebih luas melalui platform online, meningkatkan visibilitas koleksi mereka.</p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>


<section id="koleksi-buku">
  <div class="section-heading text-center">
    <h6>| buku</h6>
    <h2>Koleksi Buku</h2>
  </div>
  <div class="container mx-auto px-4 py-10">
    <style>
        .container {
            max-width: 1200px;
            margin: 0 auto;
        }
        .card-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr)); /* Memperkecil lebar card */
            gap: 16px;
        }
        .card {
            background-color: white;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            overflow: hidden;
            transition: transform 0.3s, box-shadow 0.3s;
            text-decoration: none;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            height: 450px; /* Meningkatkan tinggi card */
        }
        .card:hover {
            transform: translateY(-4px);
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
        }
        .card-image {
            width: 100%;
            height: 400px; /* Memperbesar tinggi gambar */
            object-fit: cover;
        }
        .card-content {
            padding: 16px;
            height: 170px; /* Mengurangi tinggi konten teks */
            overflow: hidden; /* Memastikan teks tidak meluber */
        }
        .card-title {
            font-size: 1.125rem;
            font-weight: bold;
            color: #2d3748;
            margin-bottom: 8px;
        }
        .card-author,
        .card-year,
        .card-stock {
            font-size: 0.875rem;
            color: #4a5568;
            margin-top: 4px;
        }
        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }
        .pagination a {
            margin: 0 4px;
            padding: 8px 12px;
            border: 1px solid #e2e8f0;
            border-radius: 4px;
            color: #2d3748;
            text-decoration: none;
            transition: background-color 0.3s, color 0.3s;
        }
        .pagination a:hover {
            background-color: #2d3748;
            color: white;
        }
        .pagination .active {
            background-color: #2d3748;
            color: white;
        }
    </style>

    <?php if($books->isEmpty()): ?>
        <p class="text-sm text-gray-500">Tidak terdapat buku</p>
    <?php else: ?>
        <div class="card-grid">
            <?php $__currentLoopData = $books; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $book): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('books.show', $book->slug)); ?>" class="card">
                    <img src="<?php echo e(Storage::url($book->image)); ?>" alt="<?php echo e($book->title); ?>" class="card-image">
                    <div class="card-content">
                        <h2 class="card-title"><?php echo e($book->title); ?></h2>
                        <p class="card-author">Penulis: <?php echo e($book->penulis); ?></p>
                        <p class="card-year">Tahun Terbit: <?php echo e($book->thn_terbit); ?></p>
                        <p class="card-stock">Stok: <?php echo e($book->stok); ?></p>
                    </div>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Pagination -->
        <div class="pagination">
            <?php echo e($books->links()); ?> <!-- Ini sekarang akan berfungsi karena $books adalah instance paginator -->
        </div>
    <?php endif; ?>
  </div>
</section>



  <footer>
    <div class="container">
      <div class="col-lg-8">
        <p>Copyright © 2024 Dinas Lingkungan Hidup dan Kehutanan Yogyakarta All rights reserved. 
        
      </div>
    </div>
  </footer>

  <!-- Scripts -->
  <!-- Bootstrap core JavaScript -->
  <script src="vendor/jquery/jquery.min.js"></script>
  <script src="vendor/bootstrap/js/bootstrap.min.js"></script>
  <script src="assets/js/isotope.min.js"></script>
  <script src="assets/js/owl-carousel.js"></script>
  <script src="assets/js/counter.js"></script>
  <script src="assets/js/custom.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
  <script>
    $(document).ready(function(){
      $(".owl-carousel").owlCarousel({
        items: 1,
        loop: true,
        autoplay: true,
        autoplayTimeout: 3000, // 3 detik
        autoplayHoverPause: true,
        dots: true,
        nav: true, // Menampilkan tombol prev dan next
      });
    });
  </script>
  </body>
</html><?php /**PATH C:\Users\vinad\Downloads\propus\resources\views\welcome.blade.php ENDPATH**/ ?>