<?php $__env->startSection('content'); ?>
    <div class="p-4">
        <h1 class="text-lg font-semibold text-gray-800 mb-3">Koleksi Buku</h1>
        <?php if($books->isEmpty()): ?>
            <p class="text-sm ">Tidak terdapat buku</p>
        <?php endif; ?>
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4 lg:gap-6 xl:gap-8">
            <?php $__currentLoopData = $books; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $book): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('books.show', $book->slug)); ?>"
                    class="group transition rounded-md hover:scale-95 duration-300 relative">
                    <?php
                        $dipinjam = false;
                    ?>
                    <?php if($book->borrow->isNotEmpty()): ?>
                        <?php $__currentLoopData = $book->borrow; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $borrow): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($borrow->user_id == auth()->user()->id && $borrow->status == 'meminjam'): ?>
                                <?php
                                    $dipinjam = true;
                                ?>
                                <div class="bg-zinc-800 p-3 py-1 text-white rounded-r text-sm absolute top-3">Dipinjam</div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <?php if($dipinjam == false): ?>
                        <?php if($book->stok == 0): ?>
                            <div class="bg-zinc-800 p-3 py-1 text-white rounded-r text-sm absolute top-3">Tidak Tersedia</div>
                        <?php else: ?>
                            <div class="bg-green-600 p-3 py-1 text-white rounded-r text-sm absolute top-3">Tersedia</div>
                        <?php endif; ?>
                    <?php endif; ?>
                    <img src="<?php echo e(Storage::url($book->image)); ?>" alt="<?php echo e($book->title); ?>" class="w-full h-60 md:h-80 object-cover rounded">
                    <h1 class="mt-2 font-bold text-base md:text-lg text-gray-700 truncate group-hover:truncate-none peer">
                        <?php echo e($book->title); ?></h1>
                    <div class="text-sm flex text-gray-700 items-center font-medium">
                        <i data-feather="edit-3" width="16px"></i>
                        <span class="ml-2"><?php echo e($book->penulis); ?></span>
                    </div>
                    <div class="text-sm flex text-gray-700 items-center font-medium">
                        <i data-feather="calendar" width="16px"></i>
                        <span class="ml-2"><?php echo e($book->thn_terbit); ?></span>
                    </div>
                    <div class="text-sm flex text-gray-700 items-center font-medium">
                        <i data-feather="layers" width="16px"></i>
                        <span class="ml-2"><?php echo e($book->stok); ?></span>
                    </div>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contentAdmin'); ?>
    <div class="p-4">
        <div class="flex flex-col md:flex-row justify-between items-center">
            <h1 class="text-lg font-semibold text-gray-800 mb-3">Data Buku</h1>
            <div class="flex space-x-2">
                <a href="<?php echo e(route('books.create')); ?>"
                   class="transition-all duration-500 bg-blue-500 rounded-lg text-white font-medium px-5 py-2.5 text-center hover:bg-blue-600 text-sm">Tambah Buku</a>
                <form action="<?php echo e(route('books.exportCsv')); ?>" method="GET">
                    <button type="submit" class="transition-all duration-500 bg-green-500 rounded-lg text-white font-medium px-5 py-2.5 text-center hover:bg-green-600 text-sm">Export CSV</button>
                </form>
                <form action="<?php echo e(route('books.importCsv')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <input type="file" name="file" accept=".csv" required class="text-sm">
                    <button type="submit" class="transition-all duration-500 bg-yellow-500 rounded-lg text-white font-medium px-5 py-2.5 text-center hover:bg-yellow-600 text-sm">Import CSV</button>
                </form>
            </div>
        </div>
        <div class="mt-6 overflow-auto rounded-lg shadow">
            <table class="min-w-full bg-white">
                <thead class="bg-gray-50 border-b-2 border-gray-200">
                    <tr>
                        <th class="p-3 text-sm font-semibold tracking-wide text-left">#</th>
                        <th class="p-3 text-sm font-semibold tracking-wide text-left">Kode Buku</th>
                        <th class="p-3 text-sm font-semibold tracking-wide text-left">Books Title</th>
                        <th class="p-3 text-sm font-semibold tracking-wide text-left">Penulis</th>
                        <!-- Add other headers as needed -->
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                    <?php if($books->isEmpty()): ?>
                        <tr>
                            <td colspan="7" class="p-5 text-center text-sm text-gray-700">Tidak terdapat buku</td>
                        </tr>
                    <?php endif; ?>
                    <?php $__currentLoopData = $books; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $book): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="p-3 text-sm text-gray-700 whitespace-nowrap"><?php echo e($loop->iteration); ?></td>
                            <td class="p-3 text-sm text-gray-700 whitespace-nowrap"><?php echo e($book->kode_buku); ?></td>
                            <td class="p-3 text-sm text-gray-700 whitespace-nowrap"><?php echo e($book->title); ?></td>
                            <td class="p-3 text-sm text-gray-700 whitespace-nowrap"><?php echo e($book->penulis); ?></td>
                            <!-- Add other table cells as needed -->
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\vinad\Downloads\propus\resources\views\book\books.blade.php ENDPATH**/ ?>