<?php $__env->startSection('content'); ?>
    <div class="p-4">
        <h1 class="text-lg font-semibold text-gray-800 mb-3">Koleksi Buku</h1>
        <?php if($books->isEmpty()): ?>
            <p class="text-sm ">Tidak terdapat buku</p>
        <?php endif; ?>
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4 lg:gap-6 xl:gap-8">
            <?php $__currentLoopData = $books; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $book): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('books.show', $book->slug)); ?>"
                    class="group transition rounded-md hover:scale-95 duration-300 relative">
                    <?php
                        $dipinjam = false;
                    ?>
                    <?php if($book->borrow->isNotEmpty()): ?>
                        <?php $__currentLoopData = $book->borrow; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $borrow): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($borrow->user_id == auth()->user()->id && $borrow->status == 'meminjam'): ?>
                                <?php
                                    $dipinjam = true;
                                ?>
                                <div class="bg-zinc-800 p-3 py-1 text-white rounded-r text-sm absolute top-3">Dipinjam</div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <?php if($dipinjam == false): ?>
                        <?php if($book->stok == 0): ?>
                            <div class="bg-zinc-800 p-3 py-1 text-white rounded-r text-sm absolute top-3">Tidak Tersedia</div>
                        <?php else: ?>
                            <div class="bg-green-600 p-3 py-1 text-white rounded-r text-sm absolute top-3">Tersedia</div>
                        <?php endif; ?>
                    <?php endif; ?>
                    <img src="<?php echo e(Storage::url($book->image)); ?>" alt="<?php echo e($book->title); ?>" class="w-full h-60 md:h-80 object-cover rounded">
                    <h1 class="mt-2 font-bold text-base md:text-lg text-gray-700 truncate group-hover:truncate-none peer">
                        <?php echo e($book->title); ?></h1>
                    <div class="text-sm flex text-gray-700 items-center font-medium">
                        <i data-feather="edit-3" width="16px"></i>
                        <span class="ml-2"><?php echo e($book->penulis); ?></span>
                    </div>
                    <div class="text-sm flex text-gray-700 items-center font-medium">
                        <i data-feather="calendar" width="16px"></i>
                        <span class="ml-2"><?php echo e($book->thn_terbit); ?></span>
                    </div>
                    <div class="text-sm flex text-gray-700 items-center font-medium">
                        <i data-feather="layers" width="16px"></i>
                        <span class="ml-2"><?php echo e($book->stok); ?></span>
                    </div>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contentAdmin'); ?>
    <div class="p-4">
        <div class="flex flex-col md:flex-row justify-between items-center">
                <h1 class="text-lg font-semibold text-gray-800 mb-3">Data Buku</h1>
                <div class="flex space-x-2">
                    <a href="<?php echo e(route('books.create')); ?>"
                    class="transition-all duration-500 bg-blue-500 rounded-lg text-white font-medium px-5 py-2.5 text-center hover:bg-blue-600 text-sm">Tambah Buku</a>
                    <form action="<?php echo e(route('books.exportCsv')); ?>" method="GET">
                        <button type="submit" class="transition-all duration-500 bg-green-500 rounded-lg text-white font-medium px-5 py-2.5 text-center hover:bg-green-600 text-sm">Export CSV</button>
                    </form>
                    <form action="<?php echo e(route('books.importCsv')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <input type="file" name="file" accept=".csv" required class="text-sm">
                        <button type="submit" class="transition-all duration-500 bg-yellow-500 rounded-lg text-white font-medium px-5 py-2.5 text-center hover:bg-yellow-600 text-sm">Import CSV</button>
                    </form>
                </div>
            </div>
        <div class="mt-6">
            <div class="overflow-auto rounded-lg shadow block w-full mt-5 md:mt-0 md:col-span-2">
                <table class="table-auto w-full">
                    <thead class="bg-gray-50 border-b-2 border-gray-200">
                        <tr>
                            <th class="w-10 p-3 text-sm font-semibold tracking-wide text-left">#</th>
                            <th class="w-32 p-3 text-sm font-semibold tracking-wide text-left">Books title</th>
                            <th class="w-20 p-3 text-sm font-semibold tracking-wide text-left">Penulis</th>
                            <th class="w-20 p-3 text-sm font-semibold tracking-wide text-left">Penerbit</th>
                            <th class="w-20 p-3 text-sm font-semibold tracking-wide text-left">Category</th>
                            <th class="w-20 p-3 text-sm font-semibold tracking-wide text-left">Jumlah Buku</th>
                            <th class="w-20 p-3 text-sm font-semibold tracking-wide text-left">Action</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        <?php if($books->isEmpty()): ?>
                        <tr>
                            <td colspan="7">
                                <p class="text-sm p-5">Tidak terdapat buku</p>
                            </td>
                        </tr>
                        <?php endif; ?>
                        <?php $__currentLoopData = $books; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $book): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap">
                                    <?php echo e($loop->iteration); ?>

                                </td>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap">
                                    <?php echo e($book->title); ?>

                                </td>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap">
                                    <?php echo e($book->penulis); ?>

                                </td>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap">
                                    <?php echo e($book->penerbit); ?>

                                </td>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap">
                                    <?php echo e($book->category->name); ?>

                                </td>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap">
                                    <?php echo e($book->stok); ?>

                                </td>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap">
                                    
                                    <a href="<?php echo e(route('books.edit', $book->slug)); ?>" type="submit"
                                        class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-yellow-400 hover:bg-yellow-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500 no-underline">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                            stroke-width="1.5" stroke="currentColor" class="w-5 h-5">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L10.582 16.07a4.5 4.5 0 01-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 011.13-1.897l8.932-8.931zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0115.75 21H5.25A2.25 2.25 0 013 18.75V8.25A2.25 2.25 0 015.25 6H10" />
                                        </svg>
                                    </a>
                                    
                                    <form action="<?php echo e(route('books.destroy', $book->id)); ?>" method="POST" class="inline">
                                        <?php echo method_field('delete'); ?>
                                        <?php echo csrf_field(); ?>
                                        <button
                                            class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-red-500 hover:bg-red-900 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 no-underline"
                                            id="deletePost"
                                            onclick="return confirm('Are you sure you want to delete this?');"><svg
                                                xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                stroke-width="1.5" stroke="currentColor" class="w-5 h-5">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                    d="M14.74 9l-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 01-2.244 2.077H8.084a2.25 2.25 0 01-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 00-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 013.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 00-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 00-7.5 0" />
                                            </svg>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            
            
            
        </div>
    </div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\vinad\Downloads\propus\resources\views/book/books.blade.php ENDPATH**/ ?>