<?php $__env->startSection('content'); ?>
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 p-4">
        <?php if($borrows->isEmpty()): ?>
            <p class="text-sm">Tidak ada peminjaman</p>
        <?php endif; ?>
        <?php $__currentLoopData = $borrows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $borrow): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-white rounded-lg shadow-md">
                <a href="<?php echo e(route('books.show', $borrow->book->slug)); ?>">
                    <div class="grid grid-cols-1 sm:grid-cols-3 gap-4 p-4">
                        <img src="<?php echo e(asset('storage/' . $borrow->book->image)); ?>" alt="<?php echo e($borrow->book->title); ?>"
                            class="object-cover h-40 w-full rounded-lg shadow">
                        <div class="sm:col-span-2">
                            <div class="mb-2">
                                <h1 class="font-semibold text-gray-800 text-sm">Judul</h1>
                                <p class="text-gray-800 text-sm"><?php echo e($borrow->book->title); ?></p>
                            </div>
                            <div class="mb-2">
                                <h1 class="font-semibold text-gray-800 text-sm">Dipinjam</h1>
                                <p class="text-gray-800 text-sm bg-gradient-to-br from-green-500 to-green-600 inline-block text-white p-1 px-2 rounded mt-px">
                                    <?php echo e($borrow->created_at->setTimezone('Asia/Jakarta')->format('d M Y')); ?></p>
                            </div>
                            <div class="mb-2">
                                <h1 class="font-semibold text-gray-800 text-sm">Dikembalikan</h1>
                                <?php if($borrow->status == 'meminjam'): ?>
                                    <p class="text-gray-800 text-sm bg-gradient-to-br from-red-500 to-red-600 inline-block text-white p-1 px-2 rounded mt-px">
                                        Belum dikembalikan</p>
                                <?php else: ?>
                                    <p class="text-gray-800 text-sm bg-gradient-to-br from-green-500 to-green-600 inline-block text-white p-1 px-2 rounded mt-px">
                                        <?php echo e($borrow->updated_at->setTimezone('Asia/Jakarta')->format('d M Y')); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </a>
                <div class="p-4">
                    <a href="<?php echo e(route('books.readPdf', $borrow->book->slug)); ?>" class="w-full bg-blue-600 mt-1 rounded-lg text-white font-medium p-3 text-sm inline-block text-center">Baca PDF</a>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contentAdmin'); ?>
    <div class="p-4">
        <div class="flex justify-between items-center">
            <h1 class="text-lg font-semibold text-gray-800 mb-3">Data Peminjaman</h1>
        </div>
        <div class="mt-6">
            <div class="overflow-auto rounded-lg shadow w-full mt-5">
                <table class="table-auto w-full">
                    <thead class="bg-gray-50 border-b-2 border-gray-200">
                        <tr>
                            <th class="p-3 text-sm font-semibold tracking-wide text-left">#</th>
                            <th class="p-3 text-sm font-semibold tracking-wide text-left">Kode Peminjaman</th>
                            <th class="p-3 text-sm font-semibold tracking-wide text-left">Judul Buku</th>
                            <th class="p-3 text-sm font-semibold tracking-wide text-left">Peminjam</th>
                            <th class="p-3 text-sm font-semibold tracking-wide text-left">Tgl Pinjam</th>
                            <th class="p-3 text-sm font-semibold tracking-wide text-left">Action</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        <?php if($borrows->isEmpty()): ?>
                            <tr>
                                <td colspan="6">
                                    <p class="text-sm p-5">Tidak terdapat peminjaman</p>
                                </td>
                            </tr>
                        <?php endif; ?>
                        <?php $__currentLoopData = $borrows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $borrow): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap">
                                    <?php echo e($loop->iteration); ?>

                                </td>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap">
                                    <?php echo e($borrow->kode_peminjaman); ?>

                                </td>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap">
                                    <?php echo e($borrow->book->title); ?>

                                </td>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap">
                                    <?php echo e($borrow->user->name); ?>

                                </td>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap">
                                    <?php echo e($borrow->created_at->format('d M Y')); ?>

                                </td>
                                <td class="p-3 text-sm text-gray-700 whitespace-nowrap">
                                    <form action="<?php echo e(route('borrow.update', $borrow->kode_peminjaman)); ?>" method="post">
                                        <?php echo method_field('put'); ?>
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="book_id" value="<?php echo e($borrow->book_id); ?>">
                                        <input type="hidden" name="status" value="dikembalikan">
                                        <button type="submit"
                                            class="transition-all duration-500 enabled:bg-gradient-to-br enabled:from-red-400 enabled:to-red-500 px-4 py-2 rounded-lg ml-2 font-medium text-sm enabled:text-white disabled:text-slate-800 shadow-lg focus:ring-2 focus:ring-red-500 focus:ring-offset-2 shadow-red-100 disabled:bg-slate-300 disabled:cursor-not-allowed"
                                            onclick="return confirm('Konfirmasi Pengembalian Buku')"
                                            <?php if($borrow->status == 'dikembalikan'): ?> disabled <?php endif; ?>>Kembalikan</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\vinad\Downloads\propus\resources\views/borrow/borrow.blade.php ENDPATH**/ ?>