<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PDF Viewer</title>
    <!-- Tambahkan Tailwind CSS lokal atau menggunakan NPM jika di produksi -->
    <link rel="stylesheet" href="<?php echo e(asset('css/style.css')); ?>">
</head>
<body class="bg-gray-100">
    <div class="container mx-auto p-6">
        <h1 class="text-2xl font-bold mb-6 text-center"><?php echo e($title); ?></h1>
        <div class="flex justify-center items-center">
            <div class="border rounded-lg overflow-hidden shadow-lg bg-white">
                <div style="position: relative; width: 100%; height: 600px;">
                    <canvas id="pdfViewer" class="w-full h-full"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Tambahkan PDF.js sebelum script yang menggunakannya -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.10.377/pdf.min.js"></script>
    
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const url = "<?php echo e(asset('storage/' . $book->pdf)); ?>";
            pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.10.377/pdf.worker.min.js';

            pdfjsLib.getDocument(url).promise.then(pdf => {
                pdf.getPage(1).then(page => {
                    const scale = 1.5;
                    const viewport = page.getViewport({ scale: scale });

                    const canvas = document.getElementById('pdfViewer');
                    if (!canvas) {
                        console.error("Canvas element not found");
                        return;
                    }

                    const context = canvas.getContext('2d');
                    canvas.height = viewport.height;
                    canvas.width = viewport.width;

                    const renderContext = {
                        canvasContext: context,
                        viewport: viewport
                    };
                    page.render(renderContext);
                });
            }).catch(error => {
                console.error("Error loading PDF:", error);
                alert("Gagal memuat PDF. Silakan coba lagi.");
            });
        });
    </script>
</body>
</html>
<?php /**PATH C:\Users\vinad\Downloads\propus\resources\views\book\readPdf.blade.php ENDPATH**/ ?>