<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\BooksController;
use App\Http\Controllers\BookController;
use App\Http\Controllers\BorrowController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\PDFController;
use App\Http\Controllers\WelcomeController;
use App\Http\Controllers\MemberController;
use Illuminate\Support\Facades\Route;
use Maatwebsite\Excel\Facades\Excel; // Pastikan ini ada untuk menggunakan Excel

// Route untuk tampilan awal
Route::get('/', [WelcomeController::class, 'index'])->name('welcome');

   Route::get('/books/export-csv', [BooksController::class, 'exportCsv'])->name('books.exportCsv');
   Route::post('/books/import-csv', [BooksController::class, 'importCsv'])->name('books.importCsv');
   Route::post('/borrow/return/{borrow}', [BorrowController::class, 'returnBook'])->name('borrow.return');

// Rute yang hanya bisa diakses oleh pengguna yang terautentikasi
Route::middleware(['auth'])->group(function() {
    Route::get('/books', [BooksController::class, 'index'])->name('books.index');

    // Rute untuk resource books, category, dan borrow
    Route::resource('/books', BooksController::class)->scoped([
        'book' => 'slug',  // Ganti parameter untuk book dengan slug
    ]);

    Route::resource('/category', CategoryController::class)->scoped([
        'category' => 'slug',  // Ganti parameter untuk category dengan slug
    ]);

    Route::resource('/borrow', BorrowController::class)->scoped([
        'borrow' => 'kode_peminjaman',  // Ganti parameter untuk borrow dengan kode_peminjaman
    ]);

    // Route untuk logout
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
    
    // Route untuk generate PDF
    Route::get('/generate-pdf/{id}', [PDFController::class, 'generatePDF'])->name('generate.pdf');

    Route::get('/books/{id}/view-pdf', [BooksController::class, 'pdfView'])->name('books.view-pdf');

    Route::get('/books/{book}/read', [BooksController::class, 'readPdf'])->name('books.readPdf');

    // Rute untuk member
    Route::resource('members', MemberController::class);

});

// Rute yang hanya bisa diakses oleh pengguna tamu
Route::middleware(['guest'])->group(function() {
    Route::get('/login', function () {
        return view('login', [
            'title' => 'Login',
        ]);
    })->name('login');

    Route::post('/login', [AuthController::class, 'login']);

    Route::get('/register', function () {
        return view('register', [
            'title' => 'Register',
        ]);
    })->name('register');

    Route::post('/register', [AuthController::class,'register']);
});
