@extends('layouts.main')

@section('content')
<section class="bg-white">
    <div class="flex flex-col items-center justify-center px-6 py-8 mx-auto md:h-screen lg:py-0">
        <a href="#" class="flex items-center mb-6 text-2xl font-semibold text-black">
            <img src="{{ asset('/assets/images/logo2.png') }}" width="100" alt="logo">
            <span class="font-bold text-xl tracking-wide ml-3 text-[#10375C]">E-LIBRARY DLHK DIY</span>
        </a>
        <div class="w-full bg-white rounded-lg shadow-md md:mt-0 sm:max-w-md xl:p-0 dark:bg-gray-800 dark:border-gray-700">
            <div class="p-6 space-y-4 md:space-y-6 sm:p-8">
                <h1 class="text-xl font-bold leading-tight tracking-tight text-gray-900 md:text-2xl dark:text-white">
                    Sign Up
                </h1>
                <form class="space-y-4 md:space-y-6" action="/register" method="POST" enctype="multipart/form-data">
                    @csrf
                    <!-- Grid Container for Form Inputs -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Full Name Input -->
                        <div>
                            <label for="fullName" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Nama Lengkap</label>
                            <input type="text" name="name" id="fullName" class="bg-gray-50 border @error('name') border-rose-500 @else border-gray-300 @enderror text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white" placeholder="Ferran Torrez" required value="{{ old('name') }}">
                            @error('name')
                                <p class="mt-1 text-left text-sm text-red-600 mb-0">{{ $message }}</p>
                            @enderror
                        </div>
                        <!-- Username Input -->
                        <div>
                            <label for="username" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Username</label>
                            <input type="text" name="username" id="username" class="bg-gray-50 border @error('username') border-rose-500 @else border-gray-300 @enderror text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white" placeholder="ferrantorrez" required value="{{ old('username') }}">
                            @error('username')
                                <p class="mt-1 text-left text-sm text-red-600 mb-0">{{ $message }}</p>
                            @enderror
                        </div>
                        <!-- Email Input -->
                        <div>
                            <label for="email" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Email</label>
                            <input type="email" name="email" id="email" class="bg-gray-50 border @error('email') border-rose-500 @else border-gray-300 @enderror text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white" placeholder="name@company.com" required value="{{ old('email') }}">
                            @error('email')
                                <p class="mt-1 text-left text-sm text-red-600 mb-0">{{ $message }}</p>
                            @enderror
                        </div>
                        <!-- Password Input -->
                        <div>
                            <label for="password" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Password</label>
                            <input type="password" name="password" id="password" placeholder="••••••••" class="bg-gray-50 border @error('password') border-rose-500 @else border-gray-300 @enderror text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white" required>
                            @error('password')
                                <p class="mt-1 text-left text-sm text-red-600 mb-0">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                    <!-- Address Field -->
                    <div>
                        <label for="address" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Alamat</label>
                        <input type="text" name="address" id="address" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white" placeholder="Masukkan alamat" required value="{{ old('address') }}">
                        @error('address')
                            <p class="mt-1 text-left text-sm text-red-600 mb-0">{{ $message }}</p>
                        @enderror
                    </div>
                    <!-- User Status Dropdown -->
                    <div>
                        <label for="status" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Status Pengguna</label>
                        <select name="status" id="status" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white">
                            <option value="pegawai">Pegawai</option>
                            <option value="mahasiswa">Mahasiswa</option>
                            <option value="masyarakat umum">Masyarakat Umum</option>
                        </select>
                        @error('status')
                            <p class="mt-1 text-left text-sm text-red-600 mb-0">{{ $message }}</p>
                        @enderror
                    </div>
                    <!-- Profile Image Upload -->
                    <div>
                        <label for="profile_image" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Foto Profil</label>
                        <input type="file" name="profile_image" id="profile_image" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white" accept="image/*">
                        @error('profile_image')
                            <p class="mt-1 text-left text-sm text-red-600 mb-0">{{ $message }}</p>
                        @enderror
                    </div>
                    <!-- Submit Button -->
                    <button type="submit" class="w-full text-white bg-sky-600 hover:bg-sky-700 focus:ring-4 focus:outline-none focus:ring-sky-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-sky-600 dark:hover:bg-sky-700 dark:focus:ring-sky-800">Sign up</button>
                    <p class="text-sm font-light text-gray-500 dark:text-gray-400">
                        Already have an account? <a href="/login" class="font-medium text-sky-600 hover:underline dark:text-sky-500">Sign In</a>
                    </p>
                </form>
            </div>
        </div>
    </div>
</section>
@endsection
