@extends('layouts.main')

@section('content')
    <div class="p-4 h-full">
        <div class="w-full bg-white rounded-lg p-3">
            <div class="flex">
                <a href="{{ route('books.index') }}" class="text-sm font-medium text-blue-500 flex items-center">
                    <i data-feather="arrow-left" class="w-5 h-5 text-sky-600"></i>
                    <span class="ml-2 text-sky-600">Detail Buku</span>
                </a>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mt-3 relative">
                <div class="flex flex-col items-center md:sticky md:top-0">
                    <img src="{{ asset('storage/' . $book->image) }}" alt="{{ $book->title }}" class="w-full h-64 md:h-96 object-cover rounded-lg shadow-lg">
                    <form action="{{ route('borrow.store') }}" method="post" class="w-full mt-4">
                        @csrf
                        <input type="hidden" name="user_id" value="{{ auth()->user()->id }}">
                        <input type="hidden" name="book_id" value="{{ $book->id }}">
                        <input type="hidden" name="kode_peminjaman" value="{{ date('d') . auth()->user()->id . $book->kode_buku }}">
                        <input type="hidden" name="status" value="meminjam">
                        <button type="submit" class="w-full mt-3 transition-all duration-500 bg-gradient-to-br from-blue-400 to-blue-600 rounded-lg text-white font-medium p-4 text-sm shadow-lg hover:shadow-xl hover:bg-blue-600 focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 text-center disabled:bg-slate-700 disabled:cursor-not-allowed"
                            @if ($book->stok == 0) 
                                @disabled(true) 
                            @elseif ($book->borrow->isNotEmpty()) 
                                @foreach ($book->borrow->where('status', 'meminjam') as $borrow)
                                    @if ($book->stok == 0 || $borrow->user_id == auth()->user()->id)
                                        @disabled(true) 
                                    @endif
                                @endforeach
                            @endif>
                            Pinjam
                        </button>
                    </form>
                    @if ($book->borrow->where('status', 'meminjam')->where('user_id', auth()->user()->id)->isNotEmpty())
                        <form action="{{ route('borrow.return', $book->borrow->where('status', 'meminjam')->first()->id) }}" method="post" class="w-full">
                            @csrf
                            <button type="submit" class="w-full mt-3 bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-4 rounded">
                                Kembalikan
                            </button>
                        </form>
                    @endif
                    <p class="text-slate-700 mt-2 text-sm font-medium">Jumlah Buku : {{ $book->stok }}</p>
                </div>
                <div class="col-span-3">
                    <h1 class="text-2xl md:text-3xl font-semibold text-slate-800">{{ $book->title }}</h1>
                    <h2 class="text-sm md:text-base font-medium mt-2 text-slate-700">
                        {{ $book->penulis }} - {{ $book->penerbit }}
                    </h2>
                    <div class="flex flex-wrap items-center mt-2">
                        <div class="flex items-center">
                            @if ($book->histories)
                                @if ($book->histories->isNotEmpty())
                                    @foreach ($book->histories->unique('user_id') as $history)
                                        <img src="{{ asset('storage/' . $history->user->image) }}" alt="{{ $history->user->name }}" class="w-8 h-8 md:w-10 md:h-10 overflow-hidden rounded-full object-cover border border-white relative -ml-3">
                                    @endforeach
                                @endif
                                <span class="text-slate-700 ml-2">{{ $book->histories->count() }} people have read</span>
                            @endif
                        </div>
                        <div class="flex mt-2 ml-4">
                            <h2 class="text-slate-700">| Kategori :</h2>
                            <a href="{{ route('category.show', $book->category->slug) }}" class="text-slate-700 ml-1 underline decoration-double decoration-blue-600">
                                {{ $book->category->name }}
                            </a>
                        </div>
                    </div>
                    <p class="text-base text-slate-700 mt-2">{{ $book->description }}</p>
                </div>
            </div>
        </div>
    </div>
@endsection
