<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PDF Viewer</title>
    <link rel="stylesheet" href="{{ asset('css/style.css') }}">
</head>
<body class="bg-gray-100">
    <div class="container mx-auto p-4 md:p-6">
        <!-- Wrapper untuk judul dan navigasi halaman -->
        <div class="flex flex-col md:flex-row md:justify-between items-center mb-6 space-y-4 md:space-y-0">
            <h1 class="text-2xl font-bold text-center md:text-left">{{ $title }}</h1>
            <div class="flex items-center space-x-2">
                <button id="prevPage" class="bg-blue-500 hover:bg-blue-600 text-white font-semibold px-4 py-2 rounded transition duration-200 ease-in-out">
                    Previous
                </button>
                <span id="pageInfo" class="text-gray-700">Page <span id="pageNum">1</span> of <span id="pageCount">0</span></span>
                <button id="nextPage" class="bg-blue-500 hover:bg-blue-600 text-white font-semibold px-4 py-2 rounded shadow-md hover:shadow-lg transition duration-200 ease-in-out">
                    Next
                </button>
            </div>
        </div>

        <!-- Wrapper untuk tampilan PDF -->
        <div class="flex justify-center items-center">
            <div class="border rounded-lg overflow-hidden shadow-lg bg-white w-full sm:w-11/12 md:w-4/5 lg:w-3/5 xl:w-1/2">
                <div style="position: relative; width: 100%; height: auto;">
                    <canvas id="pdfViewer" class="w-full h-auto"></canvas>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.10.377/pdf.min.js"></script>
    
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const url = "{{ asset('storage/' . $book->pdf) }}";
            pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.10.377/pdf.worker.min.js';

            let pdfDoc = null,
                pageNum = 1,
                pageIsRendering = false,
                pageNumPending = null,
                scale = 1.5;

            const canvas = document.getElementById('pdfViewer'),
                  ctx = canvas.getContext('2d');

            const renderPage = (num, viewportScale = scale) => {
                pageIsRendering = true;

                pdfDoc.getPage(num).then(page => {
                    const viewport = page.getViewport({ scale: viewportScale });
                    canvas.height = viewport.height;
                    canvas.width = viewport.width;

                    const renderContext = {
                        canvasContext: ctx,
                        viewport: viewport
                    };

                    const renderTask = page.render(renderContext);
                    renderTask.promise.then(() => {
                        pageIsRendering = false;
                        if (pageNumPending !== null) {
                            renderPage(pageNumPending, viewportScale);
                            pageNumPending = null;
                        }
                    });
                });

                document.getElementById('pageNum').textContent = num;
            };

            const queueRenderPage = num => {
                if (pageIsRendering) {
                    pageNumPending = num;
                } else {
                    renderPage(num, scale);
                }
            };

            const showPrevPage = () => {
                if (pageNum <= 1) {
                    alert("Halaman pertama sudah ditampilkan.");
                    return;
                }
                pageNum--;
                queueRenderPage(pageNum);
            };

            const showNextPage = () => {
                if (pageNum >= pdfDoc.numPages) {
                    alert("Halaman terakhir sudah ditampilkan.");
                    return;
                }
                pageNum++;
                queueRenderPage(pageNum);
            };

            const updateScale = () => {
                const width = window.innerWidth;
                scale = width < 640 ? 0.8 : width < 768 ? 1 : width < 1024 ? 1.2 : 1.5;
                queueRenderPage(pageNum);
            };

            pdfjsLib.getDocument(url).promise.then(pdfDoc_ => {
                pdfDoc = pdfDoc_;
                document.getElementById('pageCount').textContent = pdfDoc.numPages;
                updateScale();
            }).catch(error => {
                console.error("Error loading PDF:", error);
                alert("Gagal memuat PDF. Silakan coba lagi.");
            });

            window.addEventListener('resize', updateScale);
            document.getElementById('prevPage').addEventListener('click', showPrevPage);
            document.getElementById('nextPage').addEventListener('click', showNextPage);
        });
    </script>
</body>
</html>
