@extends('layouts.main')

@section('contentAdmin')
    <form action="{{ route('books.store') }}" method="POST" class="p-4 w-full" enctype="multipart/form-data">
        @csrf
        <div class="bg-white rounded-xl overflow-hidden w-3/4">
            <div class="p-3 bg-blue-500">
                <a href="{{ route('books.index') }}" class="text-sm font-medium text-blue-500 flex items-center">
                    <i data-feather="arrow-left" class="w-5 h-5 text-white"></i>
                    <span class="ml-2 text-white">Add a new book</span>
                </a>
            </div>
            <div class="w-full p-3">
                <div class="grid grid-cols-2 gap-4">
                    @foreach ([
                        ['judul', 'title', 'Judul', 'Kisah Nyata', 'slug'],
                        ['penulis', 'penulis', 'Penulis', 'Kisah Nyata', 'penulis'],
                        ['penerbit', 'penerbit', 'Penerbit', 'Kisah Nyata', 'penerbit'],
                        ['tempat_terbit', 'tempat_terbit', 'Tempat Terbit', 'Jakarta', 'tempat_terbit'],
                        ['Jumlah Buku', 'stok', 'Jumlah Buku', 'Kisah Nyata', 'stok'],
                    ] as [$labelId, $name, $labelText, $placeholder, $errorField])
                        <div>
                            <label for="{{ $labelId }}" class="block mb-2 text-sm font-medium text-gray-900">{{ $labelText }}</label>
                            <input type="text" name="{{ $name }}" id="{{ $labelId }}"
                                class="bg-gray-50 border-2 @error($errorField) dark:border-rose-500 @else dark:border-gray-300 @enderror text-gray-900 sm:text-sm rounded-lg focus:outline-none focus:ring-offset-1 focus:ring-2 focus:ring-blue-500 focus:border-white block w-full p-2.5"
                                placeholder="{{ $placeholder }}" required>
                            @error($errorField)
                                <p class="mt-1 text-left text-sm text-red-600 mb-0">{{ $message }}</p>
                            @enderror
                        </div>
                    @endforeach
                    <div>
                        <label for="category" class="block mb-2 text-sm font-medium text-gray-900">Category</label>
                        <select name="category_id" id="category"
                            class="bg-gray-50 border-2 @error('category_id') dark:border-rose-500 @else dark:border-gray-300 @enderror text-gray-900 sm:text-sm rounded-lg focus:outline-none focus:ring-offset-1 focus:ring-2 focus:ring-blue-500 focus:border-white block w-full p-2.5">
                            @foreach ($categories as $category)
                                <option value="{{ $category->id }}">{{ $category->name }}</option>
                            @endforeach
                        </select>
                        @error('category_id')
                            <p class="mt-1 text-left text-sm text-red-600 mb-0">{{ $message }}</p>
                        @enderror
                    </div>
                    <div>
                        <label for="thn_terbit" class="block mb-2 text-sm font-medium text-gray-900">Tahun Terbit</label>
                        <input type="text" name="thn_terbit" id="thn_terbit"
                            class="bg-gray-50 border-2 @error('thn_terbit') dark:border-rose-500 @else dark:border-gray-300 @enderror text-gray-900 sm:text-sm rounded-lg focus:outline-none focus:ring-offset-1 focus:ring-2 focus:ring-blue-500 focus:border-white block w-full p-2.5"
                            required>
                        @error('thn_terbit')
                            <p class="mt-1 text-left text-sm text-red-600 mb-0">{{ $message }}</p>
                        @enderror
                    </div>
                    <div>
                        <label for="kodebuku" class="block mb-2 text-sm font-medium text-gray-900">Kode Buku</label>
                        <input type="text" name="kode_buku" id="kodebuku"
                            class="bg-gray-50 border-2 @error('kode_buku') dark:border-rose-500 @else dark:border-gray-300 @enderror text-gray-900 sm:text-sm rounded-lg focus:outline-none focus:ring-offset-1 focus:ring-2 focus:ring-blue-500 focus:border-white block w-full p-2.5"
                            placeholder="049472872" required>
                        @error('kode_buku')
                            <p class="mt-1 text-left text-sm text-red-600 mb-0">{{ $message }}</p>
                        @enderror
                    </div>
                    <div>
                        <label for="edisi" class="block mb-2 text-sm font-medium text-gray-900">Edisi</label>
                        <input type="text" name="edisi" id="edisi"
                            class="bg-gray-50 border-2 @error('edisi') dark:border-rose-500 @else dark:border-gray-300 @enderror text-gray-900 sm:text-sm rounded-lg focus:outline-none focus:ring-offset-1 focus:ring-2 focus:ring-blue-500 focus:border-white block w-full p-2.5"
                            placeholder="Edisi Ketiga" required>
                        @error('edisi')
                            <p class="mt-1 text-left text-sm text-red-600 mb-0">{{ $message }}</p>
                        @enderror
                    </div>
                    <div>
                        <label for="desc" class="block mb-2 text-sm font-medium text-gray-900">Description</label>
                        <textarea name="description" id="desc" cols="30" rows="10"
                            class="bg-gray-50 border-2 @error('description') dark:border-rose-500 @else dark:border-gray-300 @enderror text-gray-900 sm:text-sm rounded-lg focus:outline-none focus:ring-offset-1 focus:ring-2 focus:ring-blue-500 focus:border-white block w-full p-2.5"></textarea>
                        @error('description')
                            <p class="mt-1 text-left text-sm text-red-600 mb-0">{{ $message }}</p>
                        @enderror
                    </div>
                    <div>
                        <label class="block"> Unggah Foto Sampul
                            <span class="sr-only">Choose profile photo</span>
                            <input type="file" name="image" class="block w-full text-sm text-slate-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-gray-50 file:text-blue-500 hover:file:bg-violet-100" onchange="showPreview(event)">
                            @error('image')
                                <p class="mt-1 text-left text-sm text-red-600 mb-0">{{ $message }}</p>
                            @enderror
                            <img id="file-ip-1-preview" class="rounded-lg mt-3">
                        </label>
                    </div >
                    <div>
                        
                        <label class="block">Unggah File PDF
                            <span class="sr-only">Pilih file PDF</span>
                            <input type="file" name="pdf" accept="application/pdf"
                                class="block w-full text-sm text-slate-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-gray-50 file:text-blue-500 hover:file:bg-violet-100"
                                onchange="showPdfName(event)">
                            @error('pdf')
                                <p class="mt-1 text-left text-sm text-red-600 mb-0">{{ $message }}</p>
                            @enderror
                            <p id="pdf-name-preview" class="mt-3 text-sm text-gray-700"></p>
                        </label>
                    </div>
                </div>
                <button class="bg-blue-600 mt-3 rounded-lg text-white font-medium p-3 text-sm">Submit</button>
            </div>
        </div>
    </form>
@endsection
