<?php

namespace App\Imports;

use App\Models\Books;
use App\Models\Category;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Illuminate\Support\Str;

class BooksImport implements ToModel, WithHeadingRow
{
    public function model(array $row)
    {
        // Mendapatkan category_id berdasarkan kategori yang diberikan
        $category = Category::where('name', $row['category'])->first();
        $category_id = $category ? $category->id : null;

        // Menangani stok, pastikan stok adalah angka
        $stok = is_numeric($row['jumlah_buku']) ? $row['jumlah_buku'] : 0;

        // Mengubah tanggal tahun terbit ke format yang sesuai (misalnya Y-m-d)
        $thn_terbit = \Carbon\Carbon::createFromFormat('Ymd', $row['tahun_terbit'])->format('Y-m-d');

        // Membuat slug otomatis dari title buku
        $slug = Str::slug($row['books title']);

        return new Books([
            'kode_buku' => $row['kode_buku'],
            'title' => $row['books title'],
            'penulis' => $row['penulis'],
            'penerbit' => $row['penerbit'],
            'category_id' => $category_id,
            'stok' => $stok,
            'thn_terbit' => $thn_terbit,
            'tempat_terbit' => $row['tempat_terbit'],
            'edisi' => $row['edisi'],
            'slug' => $slug,
            'description' => $row['deskripsi'],
            'pdf' => $row['file pdf'],
            'image' => $row['sampul'],
            'user_id' => $row['user id'],
        ]);
    }
}



