<?php

namespace App\Http\Controllers;

use App\Models\Books;
use App\Models\Category;
use App\Models\Borrow;
use App\Models\Visitor;

class WelcomeController extends Controller
{
    public function index()
    {
        // Mengambil data buku dengan pagination, misalnya 10 buku per halaman
        $books = Books::paginate(10);
        // Mengambil semua kategori
        $categories = Category::all(); 
        
        // Menghitung total buku, total peminjaman, dan total pengunjung hari ini
        $totalBooks = Books::count(); // Menghitung jumlah total buku
        $totalBorrowedBooks = Borrow::count(); // Menghitung jumlah total peminjaman
        $totalVisitors = Visitor::whereDate('created_at', today())->count(); // Menghitung pengunjung hari ini

        // Mengirimkan semua variabel ke view
        return view('welcome', [
            'books' => $books,
            'categories' => $categories,
            'totalBooks' => $totalBooks,
            'totalBorrowedBooks' => $totalBorrowedBooks,
            'totalVisitors' => $totalVisitors,
        ]);
    }
}
