<?php

use Illuminate\Support\Facades\Storage;

class PDFController extends Controller
{
    public function showPDF($id)
    {
        // Ambil data PDF berdasarkan id
        $data = PDFModel::find($id);

        // Cek apakah data ditemukan
        if (!$data || !Storage::exists($data->pdf_path)) {
            abort(404, "PDF tidak ditemukan");
        }

        // Dapatkan URL file
        $pdfUrl = Storage::url($data->pdf_path);

        // Kirim ke view dengan URL file
        return view('pdf_view', compact('pdfUrl'));
    }
}
