<?php

namespace App\Http\Controllers;

use App\Models\Books;
use App\Models\Borrow;
use App\Models\History;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class BorrowController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
{
    $title = '';
    $borrow = new Borrow;

    if (request('search') && Gate::allows('isUser')) {
        $borrow = $borrow->whereHas('book', function (Builder $query) {
            $query->where('title', 'like', '%' . request('search') . '%');
        });
    } else {
        $borrow = $borrow->where('kode_peminjaman', 'like', '%' . request('search') . '%');
    }

    if (Gate::allows('isUser')) {
        $title .= 'Borrowing';
        // Menambahkan kondisi status meminjam untuk user
        $borrow = $borrow->where('user_id', auth()->user()->id)
                         ->where('status', 'meminjam') // hanya yang belum dikembalikan
                         ->get();
    }
    if (Gate::allows('isAdmin')) {
        $title .= 'All Borrowing';
        $borrow = $borrow->where('status', 'meminjam') // hanya yang belum dikembalikan
                         ->orderByDesc('status')
                         ->get();
    }

    return view('borrow.borrow', [
        'title' => $title,
        'borrows' => $borrow
    ]);
}


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Hitung jumlah buku yang sudah dipinjam oleh user dengan status 'meminjam'
        $borrowCount = Borrow::where('user_id', $request->user_id)
                            ->where('status', 'meminjam')
                            ->count();

        // Cek apakah user sudah meminjam 3 buku
        if ($borrowCount >= 3) {
            return back()->with('errorMessage', 'Anda telah mencapai batas maksimal peminjaman buku (3 buku). Kembalikan buku terlebih dahulu untuk meminjam lagi.');
        }

        // Validasi data
        $validateData = $request->validate([
            'user_id' => 'required',
            'book_id' => 'required',
            'status' => 'required'
        ]);

        // Menghasilkan kode peminjaman unik
        $kodePeminjaman = 'P-' . $request->user_id . '-' . $request->book_id . '-' . now()->timestamp;

        // Menambahkan kode_peminjaman ke dalam data validasi
        $validateData['kode_peminjaman'] = $kodePeminjaman;

        // Ambil buku berdasarkan ID
        $book = Books::findOrFail($request->book_id);

        // Cek stok buku sebelum meminjam
        if ($book->stok <= 0) {
            return back()->with('errorMessage', 'Stok buku habis.');
        }

        // Update stok buku
        $b_update = $book->update([
            'stok' => $book->stok - 1
        ]);

        if ($b_update) {
            Borrow::create($validateData);
            History::create([
                'user_id' => $validateData['user_id'],
                'books_id' => $validateData['book_id'],
            ]);
            return back()->with('successMessage', 'Buku berhasil dipinjam');
        }

        return back()->with('errorMessage', 'Buku gagal dipinjam');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  Borrow $borrow
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Borrow $borrow)
    {
        $borrow_update = $borrow->update([
            'status' => $request->status
        ]);
        
        if ($borrow_update) {
            $book_update = Books::where('id', $request->book_id)->first();
            $book_update = $book_update->update([
                'stok' => $book_update->stok + 1
            ]);
            return $borrow_update ? back()->with('successMessage', 'Proses pengembalian berhasil') : back()->with('errorMessage', 'Proses pengembalian gagal');
        }
        return back()->with('errorMessage', 'Proses pengembalian gagal');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    /**
     * Mengembalikan buku yang dipinjam
     */
    public function returnBook(Request $request, Borrow $borrow)
    {
        $borrow->update(['status' => 'dikembalikan']);
        
        $book = Books::where('id', $borrow->book_id)->first();
        $book->update(['stok' => $book->stok + 1]);

        return back()->with('successMessage', 'Buku berhasil dikembalikan');
    }
}
