

<?php $__env->startSection('title', 'Detail Konsultasi'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto">
    <div class="bg-white p-8 rounded-lg border border-gray-200">

        
        <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6">
            <div class="mb-4 md:mb-0">
                <span class="inline-block bg-blue-500 text-white text-3xl font-bold px-4 py-2 rounded-lg shadow-md">
                    <i class="fas fa-barcode mr-2"></i>Kode: <?php echo e($detail->kode_konsultasi); ?>

                </span>
            </div>
            <div class="flex items-center space-x-4">
                <img src="<?php echo e($detail->konsultasi->user->foto ? asset('storage/' . $detail->konsultasi->user->foto) : asset('default-profile.png')); ?>"
                     class="w-16 h-16 rounded-full object-cover border-2 border-blue-300 shadow-md" alt="Foto Profil">
                <div>
                    <div class="font-semibold text-lg text-gray-900">
                        <i class="fas fa-user mr-1"></i><?php echo e($detail->konsultasi->user->nama ?? 'Nama Pengguna Tidak Tersedia'); ?>

                    </div>
                    <div class="text-gray-600 text-sm">
                        <i class="fas fa-envelope mr-1"></i><?php echo e($detail->konsultasi->user->email ?? 'Email Tidak Tersedia'); ?>

                    </div>
                </div>
            </div>
        </div>

        <hr class="my-6 border-gray-200">

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            
            <div class="lg:col-span-2 grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-4 text-base text-gray-800">

                <?php
                    $isLuring = strtolower($detail->konsultasi->jenisKonsultasi->nama_jenis ?? '') === 'luring';
                    $fields = [
                        'Jenis Konsultasi' => $isLuring ? 'Konsultasi Luring' : 'Konsultasi Daring',
                        'Topik' => $detail->topik->nama_topik ?? '-',
                        'Tanggal Dibuat' => $detail->created_at->format('d F Y H:i'),
                    ];

                    if ($isLuring) {
                        $fields['Tanggal Konsultasi'] = \Carbon\Carbon::parse($detail->tanggal_konsultasi)->format('d F Y');
                        $fields['Sesi'] = $detail->sesi->nama_sesi ?? '-';
                    }
                ?>

                <?php $__currentLoopData = $fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div>
                        <span class="font-semibold text-gray-700"><i class="fas fa-circle-info mr-1"></i><?php echo e($label); ?>:</span>
                        <p class="mt-1"><?php echo e($value); ?></p>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                
                <div>
                    <span class="font-semibold text-gray-700"><i class="fas fa-flag mr-1"></i>Status:</span>
                    <p class="mt-1">
                        <?php
                            $statusName = strtolower($detail->status->nama_status ?? '');
                            $statusClass = match($statusName) {
                                'diajukan' => 'bg-blue-100 text-blue-800',
                                'diproses' => 'bg-yellow-100 text-yellow-800',
                                'selesai' => 'bg-green-100 text-green-800',
                                'batal' => 'bg-red-100 text-red-800',
                                default => 'bg-gray-100 text-gray-800',
                            };
                        ?>
                        <span class="px-3 py-1 rounded-full text-xs font-medium <?php echo e($statusClass); ?>">
                            <?php echo e(ucfirst($detail->status->nama_status ?? '-')); ?>

                        </span>
                    </p>
                </div>

                
                <div class="md:col-span-2">
                    <span class="font-semibold text-gray-700"><i class="fas fa-sticky-note mr-1"></i>Catatan:</span>
                    <div class="mt-1 text-gray-800 leading-relaxed">
                        <?php echo $detail->catatan_konsultasi; ?>

                    </div>
                </div>

                
                <div class="md:col-span-2">
                    <span class="font-semibold text-gray-700"><i class="fas fa-paperclip mr-1"></i>Lampiran:</span><br>
                    <?php
                        $filePath = $detail->lampiran->lampiran ?? null;
                        $fileUrl = $filePath ? asset('storage/' . $filePath) : null;
                        $fileName = $filePath ? basename($filePath) : null;
                        $extension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
                        $iconClass = match ($extension) {
                            'pdf' => 'fa-file-pdf text-red-600',
                            'doc', 'docx' => 'fa-file-word text-blue-600',
                            'xls', 'xlsx' => 'fa-file-excel text-green-600',
                            'ppt', 'pptx' => 'fa-file-powerpoint text-orange-500',
                            'jpg', 'jpeg', 'png', 'gif' => 'fa-file-image text-purple-500',
                            'zip', 'rar' => 'fa-file-archive text-yellow-600',
                            'txt' => 'fa-file-alt text-gray-600',
                            default => 'fa-file text-gray-500',
                        };
                    ?>

                    <?php if($filePath): ?>
                        <a href="<?php echo e($fileUrl); ?>" target="_blank" class="text-blue-600 hover:text-blue-800 underline mt-1 inline-flex items-center">
                            <i class="fas <?php echo e($iconClass); ?> mr-2 text-lg"></i>
                            <?php echo e($fileName); ?>

                        </a>
                    <?php else: ?>
                        <p class="mt-1 text-gray-500">- Tidak ada lampiran -</p>
                    <?php endif; ?>
                </div>
            </div>

            
            <div class="lg:col-span-1 flex items-center justify-center p-4 bg-gray-50 border rounded-lg">
                <?php echo QrCode::size(250)->generate($detail->kode_konsultasi); ?>

            </div>
        </div>

        
        <?php if($detail->status_id == 1): ?>
            <div class="mt-8 flex justify-end">
                <form action="<?php echo e(route('konsultasi.verifikasi', $detail->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit"
                            class="bg-green-600 hover:bg-green-700 text-white font-semibold px-6 py-3 rounded-lg shadow-md flex items-center">
                        <i class="fas fa-check-circle mr-2"></i>
                        <?php echo e(strtolower($detail->konsultasi->jenisKonsultasi->nama_jenis) === 'luring' ? 'Verifikasi Kehadiran' : 'Proses Konsultasi'); ?>

                    </button>
                </form>
            </div>
        <?php endif; ?>

        
        <?php if($detail->status_id == 2): ?>
            <div class="border border-blue-200 rounded-lg p-6 mt-8">
                <h2 class="text-lg font-semibold text-blue-800 mb-4"><i class="fas fa-edit mr-2"></i>Form Catatan Tindak Lanjut</h2>
                <form action="<?php echo e(route('konsultasi.tindaklanjut', $detail->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="mb-4">
                        <?php if (isset($component)) { $__componentOriginal030291ebfbe01b7b21fc10c5b0c01e4c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal030291ebfbe01b7b21fc10c5b0c01e4c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.quill-editor','data' => ['name' => 'catatan_tindaklanjut','id' => 'catatan_tindaklanjut','placeholder' => 'Masukkan catatan tindak lanjut...','height' => '250px']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('quill-editor'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'catatan_tindaklanjut','id' => 'catatan_tindaklanjut','placeholder' => 'Masukkan catatan tindak lanjut...','height' => '250px']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal030291ebfbe01b7b21fc10c5b0c01e4c)): ?>
<?php $attributes = $__attributesOriginal030291ebfbe01b7b21fc10c5b0c01e4c; ?>
<?php unset($__attributesOriginal030291ebfbe01b7b21fc10c5b0c01e4c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal030291ebfbe01b7b21fc10c5b0c01e4c)): ?>
<?php $component = $__componentOriginal030291ebfbe01b7b21fc10c5b0c01e4c; ?>
<?php unset($__componentOriginal030291ebfbe01b7b21fc10c5b0c01e4c); ?>
<?php endif; ?>
                    </div>
                    <button type="submit"
                            class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-lg font-semibold shadow-md">
                        <i class="fas fa-save mr-2"></i>Simpan Tindak Lanjut & Tandai Selesai
                    </button>
                </form>
            </div>
        <?php endif; ?>

        
        <?php if($detail->status_id == 3): ?>
            <?php
                $tindaklanjut = DB::table('tindak_lanjut_konsultasi')
                    ->where('konsultasi_id', $detail->konsultasi_id)
                    ->latest()
                    ->first();
            ?>

            <?php if($tindaklanjut): ?>
                <div class="bg-gray-100 border border-gray-200 rounded-lg p-6 mt-4">
                    <h2 class="text-lg font-semibold text-gray-800 mb-3"><i class="fas fa-comment-dots mr-2"></i>Catatan Tindak Lanjut</h2>
                    <div class="prose max-w-none text-gray-700 leading-relaxed">
                        <?php echo $tindaklanjut->catatan_tindaklanjut; ?>

                    </div>
                    <p class="text-sm text-gray-500 mt-4"><i class="fas fa-calendar-alt mr-1"></i>Dibuat pada: <?php echo e(\Carbon\Carbon::parse($tindaklanjut->created_at)->format('d F Y H:i')); ?></p>
                </div>
            <?php endif; ?>
        <?php endif; ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elig2424/public_html/perlingdlhkdiy/resources/views/dashboard/pages/konsultasi/detail.blade.php ENDPATH**/ ?>