<?php $__env->startSection('title', 'Verifikasi Email'); ?>

<?php $__env->startSection('content'); ?>
<div class="relative w-full h-screen overflow-hidden bg-gradient-to-r from-[#011F4B] to-[#03346E]">
    <?php echo $__env->make('components.pattern', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="absolute inset-0 bg-black/10 z-10"></div>

    <div class="absolute inset-0 flex items-center justify-center z-20">
        <div class="w-96 max-w-full mx-auto bg-white p-6 rounded-lg shadow-lg">
            <div class="flex justify-start mb-4">
                <img src="<?php echo e(asset('logo-dlhk.png')); ?>" alt="Logo DLHK" class="h-10">
            </div>

            <h2 class="text-xl font-semibold text-left py-4">Verifikasi Email Anda</h2>

            
            <?php echo $__env->make('components.toast', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <p class="text-gray-600 text-center mb-4">
                Kami telah mengirimkan kode verifikasi 6 digit ke email Anda <strong><?php echo e(old('email', $email ?? '')); ?></strong>.
                Silakan masukkan kode tersebut di bawah ini untuk memverifikasi akun Anda.
            </p>

            <form method="POST" action="<?php echo e(route('verification.verify')); ?>">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <input type="hidden" name="email" id="email" value="<?php echo e(old('email', $email ?? '')); ?>" class="w-full px-3 py-2 border rounded" required autofocus>
                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <label for="verification_code" class="block text-gray-700 text-sm font-medium mb-2">Kode Verifikasi</label>
                    <input type="text" id="verification_code" name="verification_code" class="shadow-sm appearance-none border rounded-lg w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent <?php $__errorArgs = ['verification_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required autofocus maxlength="6" pattern="\d{6}" title="Kode harus 6 digit angka">
                    <?php $__errorArgs = ['verification_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-xs italic mt-2"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="flex items-center justify-between">
                    <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg focus:outline-none focus:shadow-outline transition duration-200 w-full">
                        Verifikasi Email
                    </button>
                </div>
            </form>

            <div class="mt-6 text-center">
                <p class="text-gray-600 text-sm">Tidak menerima kode?</p>
                <form method="POST" action="<?php echo e(route('verification.resend')); ?>" class="inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="text-blue-600 hover:text-blue-800 text-sm font-medium focus:outline-none">
                        Kirim Ulang Kode
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elig2424/public_html/perlingdlhkdiy/resources/views/auth/verify.blade.php ENDPATH**/ ?>