<!DOCTYPE html>
<html lang="en" x-data="{ dropdownOpen: false }">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Halaman Pengguna'); ?></title>

    
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <?php echo $__env->yieldPushContent('styles'); ?>

    <script src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js" defer></script>

</head>
<body class="flex flex-col min-h-screen text-gray-900">

    <?php echo $__env->make('components.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    
    <?php echo $__env->make('components.page-header', [
        'title' => View::hasSection('title') ? trim($__env->yieldContent('title')) : 'Judul Halaman',
        'description' => View::hasSection('description') ? trim($__env->yieldContent('description')) : 'Deskripsi halaman.'
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="flex-grow">
        <main class="container mx-auto px-4 py-8 mt-16"> 
            
            <?php if (! empty(trim($__env->yieldContent('breadcrumb')))): ?>
                <nav class="bg-gray-50 p-3 rounded-lg shadow-sm mb-6 text-sm text-gray-700" aria-label="breadcrumb">
                    <ol class="list-none p-0 inline-flex">
                        <li><a href="<?php echo e(url('/')); ?>" class="text-blue-500 hover:text-blue-700">Home</a></li>
                        <span class="mx-2">/</span>
                        <?php echo $__env->yieldContent('breadcrumb'); ?>
                    </ol>
                </nav>
            <?php endif; ?>

            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>

    
    <?php echo $__env->yieldPushContent('scripts'); ?>
    <?php echo $__env->yieldContent('scripts'); ?>

    <?php echo $__env->make('components.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/elig2424/public_html/perlingdlhkdiy/resources/views/layouts/user.blade.php ENDPATH**/ ?>