

<?php $__env->startSection('title', 'Ajukan Konsultasi'); ?>
<?php $__env->startSection('description', 'Isi formulir ini untuk mengajukan permohonan konsultasi baru.'); ?>

<?php $__env->startSection('breadcrumb', 'Ajukan Konsultasi'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white p-6 rounded-lg border border-gray-200 shadow-md">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6 pb-4 border-b border-gray-200">
        <h1 class="text-3xl font-bold text-[#03346E] mb-2 md:mb-0">
            <i class="fas fa-comments text-blue-600 mr-3"></i> Ajukan Konsultasi Baru
        </h1>
        <a href="<?php echo e(url()->previous()); ?>"
           class="inline-flex items-center px-4 py-2 bg-gray-200 text-gray-800 text-sm font-semibold rounded-lg hover:bg-gray-300 transition ease-in-out duration-150">
            <i class="fas fa-arrow-left mr-2"></i> Kembali
        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <span class="block sm:inline"><?php echo e(session('success')); ?></span>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <span class="block sm:inline"><?php echo e(session('error')); ?></span>
        </div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <ul class="list-disc pl-5">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <?php
        $daringType = $jenisKonsultasis->firstWhere('nama_jenis', 'daring');
        $jenisForFormAction = $daringType ? $daringType->nama_jenis : ($jenisKonsultasis->first()->nama_jenis ?? 'default');
    ?>

    <form action="<?php echo e(route('konsultasi.storeForUser', ['jenis' => $jenisForFormAction])); ?>" method="POST" enctype="multipart/form-data" class="space-y-6">
        <?php echo csrf_field(); ?>

        
        <?php if (isset($component)) { $__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.form.select','data' => ['name' => 'jenis_konsultasi_id','id' => 'jenis_konsultasi_id','options' => $jenisKonsultasis->pluck('display_name', 'id'),'label' => 'Jenis Konsultasi','required' => true,'selected' => old('jenis_konsultasi_id', $daringType->id ?? '')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form.select'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'jenis_konsultasi_id','id' => 'jenis_konsultasi_id','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($jenisKonsultasis->pluck('display_name', 'id')),'label' => 'Jenis Konsultasi','required' => true,'selected' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(old('jenis_konsultasi_id', $daringType->id ?? ''))]); ?>
            <option value="">Pilih Jenis Konsultasi</option> 
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36)): ?>
<?php $attributes = $__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36; ?>
<?php unset($__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36)): ?>
<?php $component = $__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36; ?>
<?php unset($__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36); ?>
<?php endif; ?>


        <?php if (isset($component)) { $__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.form.select','data' => ['name' => 'topik_id','options' => $topiks->pluck('nama_topik', 'id'),'label' => 'Topik Konsultasi','required' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form.select'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'topik_id','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($topiks->pluck('nama_topik', 'id')),'label' => 'Topik Konsultasi','required' => true]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36)): ?>
<?php $attributes = $__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36; ?>
<?php unset($__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36)): ?>
<?php $component = $__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36; ?>
<?php unset($__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36); ?>
<?php endif; ?>

        
        <div id="tanggal-sesi-section" class="space-y-6">
            <?php if (isset($component)) { $__componentOriginal5c2a97ab476b69c1189ee85d1a95204b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5c2a97ab476b69c1189ee85d1a95204b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.form.input','data' => ['name' => 'tanggal_konsultasi','label' => 'Tanggal Konsultasi','type' => 'date','required' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form.input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'tanggal_konsultasi','label' => 'Tanggal Konsultasi','type' => 'date','required' => true]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5c2a97ab476b69c1189ee85d1a95204b)): ?>
<?php $attributes = $__attributesOriginal5c2a97ab476b69c1189ee85d1a95204b; ?>
<?php unset($__attributesOriginal5c2a97ab476b69c1189ee85d1a95204b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5c2a97ab476b69c1189ee85d1a95204b)): ?>
<?php $component = $__componentOriginal5c2a97ab476b69c1189ee85d1a95204b; ?>
<?php unset($__componentOriginal5c2a97ab476b69c1189ee85d1a95204b); ?>
<?php endif; ?>

            <?php if (isset($component)) { $__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.form.select','data' => ['name' => 'sesi_konsultasi_id','options' => $sesis->pluck('nama_sesi', 'id'),'label' => 'Sesi Konsultasi','required' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form.select'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'sesi_konsultasi_id','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($sesis->pluck('nama_sesi', 'id')),'label' => 'Sesi Konsultasi','required' => true]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36)): ?>
<?php $attributes = $__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36; ?>
<?php unset($__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36)): ?>
<?php $component = $__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36; ?>
<?php unset($__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36); ?>
<?php endif; ?>
        </div>

        <?php if (isset($component)) { $__componentOriginal030291ebfbe01b7b21fc10c5b0c01e4c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal030291ebfbe01b7b21fc10c5b0c01e4c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.quill-editor','data' => ['label' => 'Catatan Konsultasi','name' => 'catatan_konsultasi','value' => old('catatan_konsultasi'),'placeholder' => 'Tuliskan catatan tambahan...']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('quill-editor'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['label' => 'Catatan Konsultasi','name' => 'catatan_konsultasi','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(old('catatan_konsultasi')),'placeholder' => 'Tuliskan catatan tambahan...']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal030291ebfbe01b7b21fc10c5b0c01e4c)): ?>
<?php $attributes = $__attributesOriginal030291ebfbe01b7b21fc10c5b0c01e4c; ?>
<?php unset($__attributesOriginal030291ebfbe01b7b21fc10c5b0c01e4c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal030291ebfbe01b7b21fc10c5b0c01e4c)): ?>
<?php $component = $__componentOriginal030291ebfbe01b7b21fc10c5b0c01e4c; ?>
<?php unset($__componentOriginal030291ebfbe01b7b21fc10c5b0c01e4c); ?>
<?php endif; ?>

        <div class="mb-4 p-4 bg-blue-50 border border-blue-200 text-blue-800 rounded-lg">
            <h3 class="text-lg font-semibold mb-2 flex items-center">
                <i class="fas fa-paperclip mr-2"></i> Informasi Lampiran (Opsional)
            </h3>
            <p class="mb-2">Anda dapat melampirkan dokumen pendukung untuk permohonan konsultasi Anda. Ini opsional, namun sangat direkomendasikan agar kami dapat lebih memahami kebutuhan Anda sebelum konsultasi.</p>
            <ul class="list-disc pl-5 mb-2">
                <li>Jenis File yang Didukung: PDF (.pdf), Dokumen Word (.doc, .docx), Gambar (.jpg, .jpeg, .png, .gif).</li>
                <li>Batas Ukuran File: Maksimal 2MB per lampiran. Jika file Anda lebih besar, mohon kompres atau berikan tautan ke layanan penyimpanan cloud di bagian "Catatan Konsultasi".</li>
            </ul>
            <p>
                Petunjuk Unggah: Klik tombol "Pilih File" atau "Browse" di bawah ini, lalu pilih file yang ingin Anda lampirkan dari perangkat Anda. Nama file akan muncul setelah dipilih.
            </p>
        </div>

        <?php if (isset($component)) { $__componentOriginalb325d6299e3e80731b0f9f64a9bce8ed = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalb325d6299e3e80731b0f9f64a9bce8ed = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.form.file-upload','data' => ['name' => 'lampiran','label' => 'Lampiran (Opsional)']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form.file-upload'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'lampiran','label' => 'Lampiran (Opsional)']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalb325d6299e3e80731b0f9f64a9bce8ed)): ?>
<?php $attributes = $__attributesOriginalb325d6299e3e80731b0f9f64a9bce8ed; ?>
<?php unset($__attributesOriginalb325d6299e3e80731b0f9f64a9bce8ed); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb325d6299e3e80731b0f9f64a9bce8ed)): ?>
<?php $component = $__componentOriginalb325d6299e3e80731b0f9f64a9bce8ed; ?>
<?php unset($__componentOriginalb325d6299e3e80731b0f9f64a9bce8ed); ?>
<?php endif; ?>

        <div class="text-right">
            <?php if (isset($component)) { $__componentOriginal8a31ff0802d1df0c26bb607f30439b3a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8a31ff0802d1df0c26bb607f30439b3a = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.form.button','data' => ['type' => 'submit']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form.button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'submit']); ?>
                <i class="fas fa-paper-plane mr-2"></i> Kirim Permohonan
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8a31ff0802d1df0c26bb607f30439b3a)): ?>
<?php $attributes = $__attributesOriginal8a31ff0802d1df0c26bb607f30439b3a; ?>
<?php unset($__attributesOriginal8a31ff0802d1df0c26bb607f30439b3a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8a31ff0802d1df0c26bb607f30439b3a)): ?>
<?php $component = $__componentOriginal8a31ff0802d1df0c26bb607f30439b3a; ?>
<?php unset($__componentOriginal8a31ff0802d1df0c26bb607f30439b3a); ?>
<?php endif; ?>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const jenisKonsultasiSelect = document.getElementById('jenis_konsultasi_id');
            const tanggalSesiSection = document.getElementById('tanggal-sesi-section');
            const tanggalKonsultasiInput = document.getElementById('tanggal_konsultasi');
            const sesiKonsultasiSelect = document.getElementById('sesi_konsultasi_id');

            let daringJenisId = null;
            const jenisKonsultasiData = <?php echo json_encode($jenisKonsultasis->keyBy('nama_jenis'), 15, 512) ?>;

            if (jenisKonsultasiData.daring) {
                daringJenisId = jenisKonsultasiData.daring.id;
            }

            // Get the unavailable dates for luring consultations
            const unavailableLuringDates = <?php echo json_encode($tanggalTidakTersediaLuring ?? [], 15, 512) ?>;

            function toggleTanggalSesiFields() {
                if (daringJenisId === null) {
                    console.error("Kesalahan: ID untuk jenis 'daring' tidak ditemukan. Pastikan ada di tabel 'jenis_konsultasi'.");
                    tanggalSesiSection.classList.remove('hidden');
                    tanggalKonsultasiInput.setAttribute('required', 'required');
                    sesiKonsultasiSelect.setAttribute('required', 'required');
                    return;
                }

                if (jenisKonsultasiSelect.value == daringJenisId) {
                    tanggalSesiSection.classList.add('hidden');
                    tanggalKonsultasiInput.removeAttribute('required');
                    tanggalKonsultasiInput.value = '';
                    sesiKonsultasiSelect.removeAttribute('required');
                    sesiKonsultasiSelect.value = '';
                } else {
                    tanggalSesiSection.classList.remove('hidden');
                    tanggalKonsultasiInput.setAttribute('required', 'required');
                    sesiKonsultasiSelect.setAttribute('required', 'required');
                }
            }

            toggleTanggalSesiFields();
            jenisKonsultasiSelect.addEventListener('change', toggleTanggalSesiFields);

            // Add Flatpickr for date input with disabled dates
            flatpickr(tanggalKonsultasiInput, {
                dateFormat: "Y-m-d",
                minDate: "today",
                disable: [
                    // Use unavailableLuringDates for disabling
                    function(date) {
                        return unavailableLuringDates.some(item => date.toISOString().slice(0, 10) === item.date);
                    },
                ],
                onDayCreate: function(dObj, dStr, fp, dayElem) {
                    // Use unavailableLuringDates for displaying reasons
                    const matchingItem = unavailableLuringDates.find(item => dayElem.dateObj.toISOString().slice(0, 10) === item.date);
                    if (matchingItem) {
                        dayElem.innerHTML += "<span class='unavailable-reason' style='font-size: 0.7em; color: #ff0000; display: block;'>(" + matchingItem.reason + ")</span>";
                        dayElem.style.backgroundColor = '#ffe0e0';
                        dayElem.style.cursor = 'not-allowed';
                    }
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elig2424/public_html/perlingdlhkdiy/resources/views/konsultasi/create.blade.php ENDPATH**/ ?>