<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    'name' => 'content',
    'id' => 'quill-editor',
    'label' => '',
    'value' => '',
    'placeholder' => 'Tulis sesuatu...',
    'height' => '300px'
]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    'name' => 'content',
    'id' => 'quill-editor',
    'label' => '',
    'value' => '',
    'placeholder' => 'Tulis sesuatu...',
    'height' => '300px'
]); ?>
<?php foreach (array_filter(([
    'name' => 'content',
    'id' => 'quill-editor',
    'label' => '',
    'value' => '',
    'placeholder' => 'Tulis sesuatu...',
    'height' => '300px'
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<div class="space-y-2">
    <?php if($label): ?>
        <label for="<?php echo e($id); ?>" class="block text-sm font-medium text-gray-700">
            <?php echo e($label); ?>

        </label>
    <?php endif; ?>

    <div wire:ignore>
        <div id="<?php echo e($id); ?>" class="quill-editor" style="height: <?php echo e($height); ?>;"><?php echo $value; ?></div>
        <input type="hidden" name="<?php echo e($name); ?>" id="<?php echo e($id); ?>-input" value="<?php echo e($value); ?>">
    </div>
</div>

<?php if (! $__env->hasRenderedOnce('e5186fb6-8af6-43dc-9d58-2649375ea4f9')): $__env->markAsRenderedOnce('e5186fb6-8af6-43dc-9d58-2649375ea4f9'); ?>
    <?php $__env->startPush('styles'); ?>
        <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
    <?php $__env->stopPush(); ?>

    <?php $__env->startPush('scripts'); ?>
        <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>

        <script>
            document.addEventListener("DOMContentLoaded", function () {
                const editors = document.querySelectorAll('.quill-editor');

                editors.forEach(function (editor) {
                    const id = editor.id;
                    const input = document.getElementById(id + '-input');

                    const quill = new Quill('#' + id, {
                        theme: 'snow',
                        placeholder: editor.getAttribute('placeholder') || 'Tulis sesuatu...',
                        modules: {
                            toolbar: [
                                [{ 'font': [] }, { 'size': [] }],
                                ['bold', 'italic', 'underline', 'strike'],
                                [{ 'color': [] }, { 'background': [] }],
                                [{ 'script': 'sub' }, { 'script': 'super' }],
                                [{ 'header': 1 }, { 'header': 2 }, 'blockquote', 'code-block'],
                                [{ 'list': 'ordered' }, { 'list': 'bullet' }, { 'indent': '-1' }, { 'indent': '+1' }],
                                [{ 'direction': 'rtl' }, { 'align': [] }],
                                ['link', 'image', 'video'],
                                ['clean']
                            ]
                        }
                    });

                    // Image upload handler
                    const toolbar = quill.getModule('toolbar');
                    toolbar.addHandler('image', () => {
                        const inputImage = document.createElement('input');
                        inputImage.setAttribute('type', 'file');
                        inputImage.setAttribute('accept', 'image/*');
                        inputImage.click();

                        inputImage.onchange = () => {
                            const file = inputImage.files[0];
                            if (file) {
                                const formData = new FormData();
                                formData.append('image', file);

                                fetch("<?php echo e(route('layanan.uploadImage')); ?>", {
                                    method: 'POST',
                                    headers: {
                                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                                    },
                                    body: formData
                                })
                                .then(response => response.json())
                                .then(result => {
                                    if (result.success) {
                                        const range = quill.getSelection(true);
                                        quill.insertEmbed(range.index, 'image', result.url);
                                    } else {
                                        alert('Upload gagal: ' + result.message);
                                    }
                                })
                                .catch(error => {
                                    console.error('Error upload:', error);
                                    alert('Upload gambar gagal.');
                                });
                            }
                        };
                    });

                    // Set initial content
                    if (input.value) {
                        quill.root.innerHTML = input.value;
                    }

                    // Sync to hidden input
                    quill.on('text-change', function () {
                        input.value = quill.root.innerHTML;
                    });
                });
            });
        </script>

        <style>
            .quill-editor img {
                max-width: 100%;
                height: auto;
                display: block;
                margin: 10px 0;
            }
        </style>
    <?php $__env->stopPush(); ?>
<?php endif; ?>
<?php /**PATH /home/elig2424/public_html/perlingdlhkdiy/resources/views/components/quill-editor.blade.php ENDPATH**/ ?>