<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    'name',
    'required' => false,
    'value' => '',
    'label' => null,
    'placeholder' => '',
]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    'name',
    'required' => false,
    'value' => '',
    'label' => null,
    'placeholder' => '',
]); ?>
<?php foreach (array_filter(([
    'name',
    'required' => false,
    'value' => '',
    'label' => null,
    'placeholder' => '',
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<div class="mb-4">
    
    <label for="<?php echo e($name); ?>" class="block mb-1 text-sm font-medium text-gray-700">
        <?php echo e($label ?? ucwords(str_replace('_', ' ', $name))); ?>

    </label>

    <div class="relative">
        
        <input
            type="password"
            name="<?php echo e($name); ?>"
            id="<?php echo e($name); ?>"
            value="<?php echo e(old($name, $value)); ?>"
            placeholder="<?php echo e($placeholder); ?>"
            <?php echo e($required ? 'required' : ''); ?>

            class="appearance-none border border-gray-300 rounded-lg w-full py-2 px-3 pr-10 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
        />

        
        <div
            class="absolute inset-y-0 right-0 flex items-center pr-3 text-gray-500 cursor-pointer"
            onclick="togglePassword('<?php echo e($name); ?>')"
        >
            <i id="icon-<?php echo e($name); ?>" class="fa-solid fa-eye"></i>
        </div>
    </div>

    
    <?php if (isset($component)) { $__componentOriginal8a61cf4ce6144d9e2012fbc98db0155f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8a61cf4ce6144d9e2012fbc98db0155f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.form.error','data' => ['name' => $name]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form.error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($name)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8a61cf4ce6144d9e2012fbc98db0155f)): ?>
<?php $attributes = $__attributesOriginal8a61cf4ce6144d9e2012fbc98db0155f; ?>
<?php unset($__attributesOriginal8a61cf4ce6144d9e2012fbc98db0155f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8a61cf4ce6144d9e2012fbc98db0155f)): ?>
<?php $component = $__componentOriginal8a61cf4ce6144d9e2012fbc98db0155f; ?>
<?php unset($__componentOriginal8a61cf4ce6144d9e2012fbc98db0155f); ?>
<?php endif; ?>
</div>

<?php if (! $__env->hasRenderedOnce('ed4e24a8-4516-4ddf-99f8-0767f9faf912')): $__env->markAsRenderedOnce('ed4e24a8-4516-4ddf-99f8-0767f9faf912'); ?>
    <?php $__env->startPush('scripts'); ?>
        <script>
            function togglePassword(id) {
                const input = document.getElementById(id);
                const icon = document.getElementById('icon-' + id);
                const isPassword = input.getAttribute('type') === 'password';
                input.setAttribute('type', isPassword ? 'text' : 'password');
                icon.classList.toggle('fa-eye');
                icon.classList.toggle('fa-eye-slash');
            }
        </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>
<?php /**PATH /home/elig2424/public_html/perlingdlhkdiy/resources/views/components/form/password.blade.php ENDPATH**/ ?>