<!DOCTYPE html>
<html lang="en" x-data="{ sidebarOpen: false, sidebarCollapse: false, dropdownOpen: false }">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Admin Panel'); ?></title>

    
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="font-montserrat bg-gray-100">

    <?php echo $__env->make('dashboard.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Overlay untuk mobile -->
    <div
        class="fixed inset-0 bg-black bg-opacity-50 z-20 md:hidden"
        x-show="sidebarOpen"
        x-transition.opacity
        @click="sidebarOpen = false"
    ></div>

    <?php echo $__env->make('dashboard.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div
        class="flex flex-col min-h-screen transition-all duration-300 ease-in-out pt-16"
        :class="sidebarCollapse ? 'md:ml-20' : 'md:ml-64'"
    >
        <main class="flex-1 p-6 rounded-lg bg-white shadow-lg transition-all duration-300 ease-in-out">
            
            <!-- Page Title + Breadcrumb -->
            <div class="flex justify-between items-center mb-6">
                <h2 class="text-xl font-bold"><?php echo $__env->yieldContent('title', 'Halaman'); ?></h2>
                <nav class="text-sm text-gray-600">
                    <ul class="flex items-center space-x-2">
                        <li><a href="#" class="hover:text-blue-600">Home</a></li>
                        <li>&gt;</li>
                        <li><span class="text-blue-600"><?php echo $__env->yieldContent('breadcrumb', 'Halaman'); ?></span></li>
                    </ul>
                </nav>
            </div>

            <!-- Main Content -->
            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>

    
    <?php echo $__env->yieldPushContent('scripts'); ?>
<?php echo $__env->yieldContent('scripts'); ?>
</body>
</html>
<?php /**PATH G:\MBUHH\sistem-p3klh-dlhk\resources\views/dashboard/layouts/adminlayout.blade.php ENDPATH**/ ?>