<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps(['name', 'label']) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps(['name', 'label']); ?>
<?php foreach (array_filter((['name', 'label']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<div class="mb-6">
    
    <label for="<?php echo e($name); ?>" class="block text-lg font-semibold text-gray-800 mb-3">
        <?php echo e($label); ?>

    </label>

    
    <div
        id="drop-area"
        class="flex flex-col items-center justify-center border-2 border-dashed border-gray-300 rounded-xl p-6 bg-white hover:border-blue-400 transition cursor-pointer text-center"
        onclick="document.getElementById('<?php echo e($name); ?>').click();"
        ondragover="event.preventDefault(); this.classList.add('border-blue-400')"
        ondragleave="this.classList.remove('border-blue-400')"
        ondrop="handleDrop(event)"
    >
        <svg class="w-12 h-12 text-gray-400 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
        </svg>
        <p class="text-gray-600 text-sm">Drag and drop or <span class="text-blue-600 underline">browse</span> your files (PDF/Image)</p>
    </div>

    
    <input
        type="file"
        name="<?php echo e($name); ?>"
        id="<?php echo e($name); ?>"
        class="hidden"
        accept="application/pdf,image/png,image/jpeg,image/jpg"
        onchange="handleFileUpload(event)"
    >

    
    <div id="file-info" class="mt-4 hidden">
        <div class="flex items-center gap-3">
            <div id="file-icon" class="w-10 h-10 flex items-center justify-center bg-gray-100 rounded text-xl text-blue-600">
                <!-- Icon dinamis -->
            </div>
            <div class="w-full">
                <p id="file-name" class="text-sm font-medium text-gray-700 truncate"></p>
                <div class="w-full bg-gray-200 rounded-full h-2 mt-1">
                    <div id="upload-progress" class="bg-blue-500 h-2 rounded-full transition-all duration-300 ease-in-out" style="width: 0%"></div>
                </div>
                <p id="upload-status" class="text-xs text-blue-500 mt-1">Uploading... <span id="progress-text">0%</span></p>
            </div>

            
            <button
                onclick="resetFileUpload()"
                type="button"
                class="text-red-500 hover:text-red-700 transition"
                title="Hapus Lampiran"
            >
                <i class="fa-solid fa-trash text-lg"></i>
            </button>
        </div>
    </div>

    
    <div id="upload-success" class="mt-4 hidden flex items-center text-green-600 text-sm font-medium">
        <svg class="w-5 h-5 mr-2 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
        </svg>
        File uploaded successfully.
    </div>

    
    <?php if (isset($component)) { $__componentOriginal8a61cf4ce6144d9e2012fbc98db0155f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8a61cf4ce6144d9e2012fbc98db0155f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.form.error','data' => ['name' => $name]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form.error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($name)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8a61cf4ce6144d9e2012fbc98db0155f)): ?>
<?php $attributes = $__attributesOriginal8a61cf4ce6144d9e2012fbc98db0155f; ?>
<?php unset($__attributesOriginal8a61cf4ce6144d9e2012fbc98db0155f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8a61cf4ce6144d9e2012fbc98db0155f)): ?>
<?php $component = $__componentOriginal8a61cf4ce6144d9e2012fbc98db0155f; ?>
<?php unset($__componentOriginal8a61cf4ce6144d9e2012fbc98db0155f); ?>
<?php endif; ?>
</div>

<?php if (! $__env->hasRenderedOnce('295b20cc-484d-4feb-a3e2-c8adabb392c8')): $__env->markAsRenderedOnce('295b20cc-484d-4feb-a3e2-c8adabb392c8'); ?>
    <?php $__env->startPush('scripts'); ?>
        <script>
            function handleDrop(e) {
                e.preventDefault();
                const files = e.dataTransfer.files;
                if (files.length) {
                    document.getElementById('<?php echo e($name); ?>').files = files;
                    handleFileUpload({ target: { files } });
                }
            }

            function handleFileUpload(e) {
                const file = e.target.files[0];
                if (!file) return;

                const allowedTypes = ['application/pdf', 'image/png', 'image/jpeg'];
                if (!allowedTypes.includes(file.type)) {
                    alert('File tidak didukung. Hanya PDF dan gambar yang diperbolehkan.');
                    return;
                }

                const icon = document.getElementById('file-icon');
                const info = document.getElementById('file-info');
                const nameEl = document.getElementById('file-name');
                const progressBar = document.getElementById('upload-progress');
                const progressText = document.getElementById('progress-text');
                const status = document.getElementById('upload-status');
                const successMessage = document.getElementById('upload-success');

                // Set icon sesuai file type
                if (file.type === 'application/pdf') {
                    icon.innerHTML = `<i class="fa-solid fa-file-pdf text-red-600"></i>`;
                } else {
                    icon.innerHTML = `<i class="fa-solid fa-file-image text-blue-500"></i>`;
                }

                nameEl.textContent = file.name;
                info.classList.remove('hidden');
                successMessage.classList.add('hidden');

                // Simulasi upload dengan progress
                let uploaded = 0;
                const total = file.size;
                const interval = setInterval(() => {
                    uploaded += total * 0.05;
                    const percent = Math.min(100, Math.round((uploaded / total) * 100));
                    progressBar.style.width = percent + '%';
                    progressText.textContent = percent + '%';

                    if (percent >= 100) {
                        clearInterval(interval);
                        status.textContent = 'Upload complete';
                        successMessage.classList.remove('hidden');
                    }
                }, 100);
            }

            function resetFileUpload() {
                const fileInput = document.getElementById('<?php echo e($name); ?>');
                const fileInfo = document.getElementById('file-info');
                const fileName = document.getElementById('file-name');
                const progressBar = document.getElementById('upload-progress');
                const progressText = document.getElementById('progress-text');
                const status = document.getElementById('upload-status');
                const successMessage = document.getElementById('upload-success');
                const fileIcon = document.getElementById('file-icon');

                fileInput.value = '';
                fileInfo.classList.add('hidden');
                successMessage.classList.add('hidden');

                fileName.textContent = '';
                progressBar.style.width = '0%';
                progressText.textContent = '0%';
                status.textContent = 'Uploading...';
                fileIcon.innerHTML = '';
            }
        </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>
<?php /**PATH /home/elig2424/public_html/perlingdlhkdiy/resources/views/components/form/file-upload.blade.php ENDPATH**/ ?>